/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.util.List;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.TimeAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.FunctionBase;
import org.wso2.balana.ctx.EvaluationCtx;

public class TimeInRangeFunction
extends FunctionBase {
    public static final String NAME = "urn:oasis:names:tc:xacml:2.0:function:time-in-range";
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_DAY = 86400000L;

    public TimeInRangeFunction() {
        super(NAME, 0, "http://www.w3.org/2001/XMLSchema#time", false, 3, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        long maxTime;
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        TimeAttribute attr = (TimeAttribute)argValues[0];
        long middleTime = attr.getMilliseconds();
        long minTime = this.resolveTime(attr, (TimeAttribute)argValues[1]);
        if (minTime == (maxTime = this.resolveTime(attr, (TimeAttribute)argValues[2]))) {
            return EvaluationResult.getInstance(middleTime == minTime);
        }
        long shiftSpan = minTime < maxTime ? -minTime : 86400000L - minTime;
        middleTime = this.handleWrap(middleTime + shiftSpan);
        return EvaluationResult.getInstance(middleTime >= 0L && middleTime <= (maxTime += shiftSpan));
    }

    private long resolveTime(TimeAttribute middleTime, TimeAttribute otherTime) {
        long time = otherTime.getMilliseconds();
        int tz = otherTime.getTimeZone();
        if (tz == -1000000) {
            int middleTz = middleTime.getTimeZone();
            tz = otherTime.getDefaultedTimeZone();
            if (middleTz == -1000000) {
                middleTz = middleTime.getDefaultedTimeZone();
            }
            if (middleTz != tz) {
                time -= (long)(middleTz - tz) * 60000L;
                time = this.handleWrap(time);
            }
        }
        return time;
    }

    private long handleWrap(long time) {
        if (time < 0L) {
            return time + 86400000L;
        }
        if (time > 86400000L) {
            return time - 86400000L;
        }
        return time;
    }
}

