/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.cond.Expression;
import org.wso2.balana.cond.ExpressionHandler;
import org.wso2.balana.cond.VariableManager;

public class VariableDefinition {
    private String variableId;
    private Expression expression;

    public VariableDefinition(String variableId, Expression expression) {
        this.variableId = variableId;
        this.expression = expression;
    }

    public static VariableDefinition getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        String variableId = root.getAttributes().getNamedItem("VariableId").getNodeValue();
        NodeList nodes = root.getChildNodes();
        Node xprNode = nodes.item(0);
        int i = 1;
        while (xprNode.getNodeType() != 1) {
            xprNode = nodes.item(i++);
        }
        Expression xpr = ExpressionHandler.parseExpression(xprNode, metaData, manager);
        return new VariableDefinition(variableId, xpr);
    }

    public String getVariableId() {
        return this.variableId;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    public void encode(StringBuilder builder) {
        builder.append("<VariableDefinition VariableId=\"").append(this.variableId).append("\">\n");
        this.expression.encode(builder);
        builder.append("</VariableDefinition>\n");
    }
}

