/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond.xacml3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.DefaultNamespaceContext;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.IntegerAttribute;
import org.wso2.balana.attr.xacml3.XPathAttribute;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.FunctionBase;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.ctx.xacml3.XACML3EvaluationCtx;
import org.wso2.balana.xacml3.Attributes;

public class XPathFunction
extends FunctionBase {
    public static final String NAME_XPATH_NODE_COUNT = "urn:oasis:names:tc:xacml:3.0:function:xpath-node-count";
    public static final String NAME_XPATH_NODE_MATCH = "urn:oasis:names:tc:xacml:3.0:function:xpath-node-match";
    public static final String NAME_XPATH_NODE_EQUAL = "urn:oasis:names:tc:xacml:3.0:function:xpath-node-equal";
    private static final int ID_XPATH_NODE_COUNT = 0;
    private static final int ID_XPATH_NODE_MATCH = 1;
    private static final int ID_XPATH_NODE_EQUAL = 2;

    public XPathFunction(String functionName) {
        super(functionName, XPathFunction.getId(functionName), "urn:oasis:names:tc:xacml:3.0:data-type:xpathExpression", false, XPathFunction.getNumArgs(functionName), XPathFunction.getReturnType(functionName), false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_XPATH_NODE_COUNT)) {
            return 0;
        }
        if (functionName.equals(NAME_XPATH_NODE_EQUAL)) {
            return 2;
        }
        if (functionName.equals(NAME_XPATH_NODE_MATCH)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown divide function " + functionName);
    }

    private static String getReturnType(String functionName) {
        if (functionName.equals(NAME_XPATH_NODE_COUNT)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        return "http://www.w3.org/2001/XMLSchema#boolean";
    }

    private static int getNumArgs(String functionName) {
        if (functionName.equals(NAME_XPATH_NODE_COUNT)) {
            return 1;
        }
        return 2;
    }

    public static Set<String> getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_XPATH_NODE_COUNT);
        set.add(NAME_XPATH_NODE_EQUAL);
        set.add(NAME_XPATH_NODE_MATCH);
        return set;
    }

    @Override
    public EvaluationResult evaluate(List<Evaluatable> inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        switch (this.getFunctionId()) {
            case 0: {
                XPathAttribute xpathAttribute = (XPathAttribute)argValues[0];
                String xpathValue = xpathAttribute.getValue();
                String category = xpathAttribute.getXPathCategory();
                Node contextNode = null;
                List<Attributes> attributesSet = ((XACML3EvaluationCtx)context).getAttributes(category);
                if (attributesSet != null && attributesSet.size() > 0) {
                    Attributes attributes = attributesSet.get(0);
                    contextNode = attributes.getContent();
                }
                if (contextNode == null) break;
                try {
                    NodeList nodeList = this.getXPathResults(contextNode, xpathValue);
                    return new EvaluationResult(new IntegerAttribute(nodeList.getLength()));
                }
                catch (XPathExpressionException e) {
                    ArrayList<String> codes = new ArrayList<String>();
                    codes.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
                    Status status = new Status(codes, e.getMessage());
                    return new EvaluationResult(status);
                }
            }
        }
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
        Status status = new Status(codes, "Not supported function");
        return new EvaluationResult(status);
    }

    private NodeList getXPathResults(Node contextNode, String xpathValue) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String namespace = contextNode.getNamespaceURI();
        NamedNodeMap namedNodeMap = contextNode.getAttributes();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node n = namedNodeMap.item(i);
            String prefix = DOMHelper.getLocalName(n);
            String nodeValue = n.getNodeValue();
            nsMap.put(prefix, nodeValue);
        }
        if ("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17".equals(namespace) || "urn:oasis:names:tc:xacml:2.0:context:schema:os".equals(namespace) || "urn:oasis:names:tc:xacml:1.0:context".equals(namespace)) {
            nsMap.put("xacml", namespace);
        }
        DefaultNamespaceContext namespaceContext = new DefaultNamespaceContext(nsMap);
        xpath.setNamespaceContext(namespaceContext);
        XPathExpression expression = xpath.compile(xpathValue);
        return (NodeList)expression.evaluate(contextNode, XPathConstants.NODESET);
    }
}

