/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.xacml3.Result;

public class ResponseCtx {
    private Set<AbstractResult> results = new HashSet<AbstractResult>();
    private int version;

    public ResponseCtx(AbstractResult result) {
        this.version = result.getVersion();
        this.results.add(result);
    }

    public ResponseCtx(Set<AbstractResult> results, int version) {
        this.version = version;
        this.results = Collections.unmodifiableSet(new HashSet<AbstractResult>(results));
    }

    public static ResponseCtx getInstance(Node root) throws ParsingException {
        String requestCtxNs = root.getNamespaceURI();
        if (requestCtxNs != null) {
            if ("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17".equals(requestCtxNs.trim())) {
                return ResponseCtx.getInstance(root, 3);
            }
            if ("urn:oasis:names:tc:xacml:1.0:context".equals(requestCtxNs.trim()) || "urn:oasis:names:tc:xacml:2.0:context:schema:os".equals(requestCtxNs.trim())) {
                return ResponseCtx.getInstance(root, 2);
            }
            throw new ParsingException("Invalid namespace in XACML response");
        }
        return ResponseCtx.getInstance(root, 3);
    }

    public static ResponseCtx getInstance(Node root, int version) throws ParsingException {
        HashSet<AbstractResult> results = new HashSet<AbstractResult>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("Result")) continue;
            if (version == 3) {
                results.add(Result.getInstance(node));
                continue;
            }
            results.add(org.wso2.balana.ctx.xacml2.Result.getInstance(node));
        }
        if (results.size() == 0) {
            throw new ParsingException("must have at least one Result");
        }
        return new ResponseCtx(results, version);
    }

    public Set<AbstractResult> getResults() {
        return this.results;
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    public void encode(StringBuilder builder) {
        builder.append("<Response");
        if (this.version == 3) {
            builder.append(" xmlns=\"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17\"");
        }
        builder.append(">");
        for (AbstractResult result : this.results) {
            result.encode(builder);
        }
        builder.append("</Response>");
    }
}

