/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.finder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.finder.ResourceFinderModule;
import org.wso2.balana.finder.ResourceFinderResult;

public class ResourceFinder {
    private List<ResourceFinderModule> allModules = new ArrayList<ResourceFinderModule>();
    private List<ResourceFinderModule> childModules = new ArrayList<ResourceFinderModule>();
    private List<ResourceFinderModule> descendantModules = new ArrayList<ResourceFinderModule>();
    private static Log logger = LogFactory.getLog(ResourceFinder.class);

    public List<ResourceFinderModule> getModules() {
        return new ArrayList<ResourceFinderModule>(this.allModules);
    }

    public void setModules(List<ResourceFinderModule> modules) {
        Iterator<ResourceFinderModule> it = modules.iterator();
        this.allModules = new ArrayList<ResourceFinderModule>(modules);
        this.childModules = new ArrayList<ResourceFinderModule>();
        this.descendantModules = new ArrayList<ResourceFinderModule>();
        while (it.hasNext()) {
            ResourceFinderModule module = it.next();
            if (module.isChildSupported()) {
                this.childModules.add(module);
            }
            if (!module.isDescendantSupported()) continue;
            this.descendantModules.add(module);
        }
    }

    public ResourceFinderResult findChildResources(AttributeValue parentResourceId, EvaluationCtx context) {
        for (ResourceFinderModule module : this.childModules) {
            ResourceFinderResult result = module.findChildResources(parentResourceId, context);
            if (result.isEmpty()) continue;
            return result;
        }
        logger.info((Object)("No ResourceFinderModule existed to handle the children of " + parentResourceId.encode()));
        return new ResourceFinderResult();
    }

    public ResourceFinderResult findChildResources(AttributeValue parentResourceId) {
        for (ResourceFinderModule module : this.childModules) {
            ResourceFinderResult result = module.findChildResources(parentResourceId);
            if (result.isEmpty()) continue;
            return result;
        }
        logger.info((Object)("No ResourceFinderModule existed to handle the children of " + parentResourceId.encode()));
        return new ResourceFinderResult();
    }

    public ResourceFinderResult findDescendantResources(AttributeValue parentResourceId, EvaluationCtx context) {
        for (ResourceFinderModule module : this.descendantModules) {
            ResourceFinderResult result = module.findDescendantResources(parentResourceId, context);
            if (result.isEmpty()) continue;
            return result;
        }
        logger.info((Object)("No ResourceFinderModule existed to handle the descendants of " + parentResourceId.encode()));
        return new ResourceFinderResult();
    }

    public ResourceFinderResult findDescendantResources(AttributeValue parentResourceId) {
        for (ResourceFinderModule module : this.descendantModules) {
            ResourceFinderResult result = module.findDescendantResources(parentResourceId);
            if (result.isEmpty()) continue;
            return result;
        }
        logger.info((Object)("No ResourceFinderModule existed to handle the descendants of " + parentResourceId.encode()));
        return new ResourceFinderResult();
    }
}

