/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml3.AllOfSelection;

public class AnyOfSelection {
    private List<AllOfSelection> allOfSelections;
    private static Log logger = LogFactory.getLog(AnyOfSelection.class);

    public AnyOfSelection(List<AllOfSelection> allOfSelections) {
        this.allOfSelections = allOfSelections == null ? new ArrayList<AllOfSelection>() : new ArrayList<AllOfSelection>(allOfSelections);
    }

    public static AnyOfSelection getInstance(Node root, PolicyMetaData metaData) throws ParsingException {
        ArrayList<AllOfSelection> allOfSelections = new ArrayList<AllOfSelection>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"AllOf".equals(DOMHelper.getLocalName(child))) continue;
            allOfSelections.add(AllOfSelection.getInstance(child, metaData));
        }
        if (allOfSelections.isEmpty()) {
            throw new ParsingException("AnyOf must contain at least one AllOf");
        }
        return new AnyOfSelection(allOfSelections);
    }

    public MatchResult match(EvaluationCtx context) {
        Status firstIndeterminateStatus = null;
        for (AllOfSelection group : this.allOfSelections) {
            MatchResult result = group.match(context);
            if (result.getResult() == 0) {
                return result;
            }
            if (result.getResult() != 2 || firstIndeterminateStatus != null) continue;
            firstIndeterminateStatus = result.getStatus();
        }
        if (firstIndeterminateStatus == null) {
            return new MatchResult(1);
        }
        return new MatchResult(2, firstIndeterminateStatus);
    }

    public void encode(StringBuilder builder) {
        builder.append("<AnyOf>\n");
        if (this.allOfSelections != null) {
            for (AllOfSelection allOfSelection : this.allOfSelections) {
                allOfSelection.encode(builder);
            }
        }
        builder.append("</AnyOf>\n");
    }
}

