/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AttributeAssignment;

public class Obligation
implements ObligationResult {
    private URI obligationId;
    private List<AttributeAssignment> assignments;

    public Obligation(List<AttributeAssignment> assignments, URI obligationId) {
        this.assignments = assignments;
        this.obligationId = obligationId;
    }

    public static Obligation getInstance(Node root) throws ParsingException {
        URI obligationId;
        ArrayList<AttributeAssignment> assignments = new ArrayList<AttributeAssignment>();
        if (!DOMHelper.getLocalName(root).equals("Obligation")) {
            throw new ParsingException("Obligation object cannot be created with root node of type: " + DOMHelper.getLocalName(root));
        }
        NamedNodeMap nodeAttributes = root.getAttributes();
        try {
            obligationId = new URI(nodeAttributes.getNamedItem("ObligationId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required ObligationId in ObligationType", e);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"AttributeAssignment".equals(DOMHelper.getLocalName(child))) continue;
            assignments.add(AttributeAssignment.getInstance(child));
        }
        return new Obligation(assignments, obligationId);
    }

    @Override
    public void encode(StringBuilder builder) {
        builder.append("<Obligation ObligationId=\"").append(this.obligationId).append("\">");
        if (this.assignments != null && this.assignments.size() > 0) {
            for (AttributeAssignment assignment : this.assignments) {
                assignment.encode(builder);
            }
        }
        builder.append("</Obligation>");
    }

    public List<AttributeAssignment> getAssignments() {
        return this.assignments;
    }

    public URI getObligationId() {
        return this.obligationId;
    }

    @Override
    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }
}

