/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.impl.CacheImpl;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class CacheCleanupTask
implements Runnable {
    private static final Log log = LogFactory.getLog(CacheCleanupTask.class);
    private List<CacheImpl> caches = new CopyOnWriteArrayList<CacheImpl>();

    public void addCacheForMonitoring(CacheImpl cache) {
        this.caches.add(cache);
    }

    public void removeCacheFromMonitoring(CacheImpl cache) {
        this.caches.remove(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cache expiry scheduler running...");
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext cc = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            cc.setTenantId(-1234);
            cc.setTenantDomain("carbon.super");
            for (CacheImpl cache : this.caches) {
                cache.runCacheExpiry();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Cache expiry completed for cache " + cache.getName()));
            }
        }
        catch (IllegalStateException e) {
            log.debug((Object)"Error occurred while running CacheCleanupTask", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while running CacheCleanupTask", e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

