/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheManager;
import javax.cache.CacheManagerFactory;
import javax.cache.CachingShutdownException;
import org.wso2.carbon.caching.impl.CacheCleanupTask;
import org.wso2.carbon.caching.impl.CacheImpl;
import org.wso2.carbon.caching.impl.CarbonCacheManager;
import org.wso2.carbon.caching.impl.TenantCacheManager;
import org.wso2.carbon.caching.impl.Util;

public class CacheManagerFactoryImpl
implements CacheManagerFactory,
TenantCacheManager {
    private static CacheCleanupTask cacheCleanupTask = new CacheCleanupTask();
    private ScheduledExecutorService cacheEvictionScheduler;
    private static ThreadFactory threadFactory;
    private static int threadCount;
    private Map<String, Map<String, CacheManager>> globalCacheManagerMap = new ConcurrentHashMap<String, Map<String, CacheManager>>();

    static void addCacheForMonitoring(CacheImpl cache) {
        cacheCleanupTask.addCacheForMonitoring(cache);
    }

    void removeCacheFromMonitoring(CacheImpl cache) {
        cacheCleanupTask.removeCacheFromMonitoring(cache);
    }

    void switchToDistributedMode() {
        for (Map<String, CacheManager> cacheManagerMap : this.globalCacheManagerMap.values()) {
            for (CacheManager cacheManager : cacheManagerMap.values()) {
                ((CarbonCacheManager)cacheManager).switchToDistributedMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheManager getCacheManager(String cacheManagerName) {
        CacheManager cacheManager;
        String tenantDomain = Util.getTenantDomain();
        if (tenantDomain == null) {
            throw new NullPointerException("Tenant domain has not been set in CarbonContext");
        }
        Map<String, CacheManager> cacheManagers = this.globalCacheManagerMap.get(tenantDomain);
        if (cacheManagers == null) {
            String string = tenantDomain.intern();
            synchronized (string) {
                cacheManagers = this.globalCacheManagerMap.get(tenantDomain);
                if (cacheManagers == null) {
                    cacheManagers = new ConcurrentHashMap<String, CacheManager>();
                    this.globalCacheManagerMap.put(tenantDomain, cacheManagers);
                }
            }
            this.ensureExpirySchedulerRunning();
        }
        if ((cacheManager = cacheManagers.get(cacheManagerName)) == null) {
            String string = (tenantDomain + "*.*" + cacheManagerName).intern();
            synchronized (string) {
                cacheManager = cacheManagers.get(cacheManagerName);
                if (cacheManager == null) {
                    cacheManager = new CarbonCacheManager(cacheManagerName, this);
                    cacheManagers.put(cacheManagerName, cacheManager);
                }
            }
        }
        return cacheManager;
    }

    @Override
    public CacheManager getCacheManager(ClassLoader classLoader, String name) {
        return this.getCacheManager(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CachingShutdownException {
        String tenantDomain = Util.getTenantDomain();
        String string = tenantDomain.intern();
        synchronized (string) {
            Map<String, CacheManager> cacheManagers = this.globalCacheManagerMap.get(tenantDomain);
            if (cacheManagers != null) {
                for (CacheManager cacheManager : cacheManagers.values()) {
                    cacheManager.shutdown();
                }
                cacheManagers.clear();
            }
        }
        if (this.cacheEvictionScheduler != null) {
            this.cacheEvictionScheduler.shutdown();
        }
    }

    @Override
    public boolean close(ClassLoader classLoader) throws CachingShutdownException {
        this.close();
        return true;
    }

    @Override
    public boolean close(ClassLoader classLoader, String name) throws CachingShutdownException {
        String tenantDomain = Util.getTenantDomain();
        Map<String, CacheManager> cacheManagers = this.globalCacheManagerMap.get(tenantDomain);
        if (cacheManagers != null) {
            CacheManager cacheManager = cacheManagers.get(name);
            cacheManager.shutdown();
            return true;
        }
        return false;
    }

    public void removeCacheManager(CarbonCacheManager cacheManager, String tenantDomain) {
        Map<String, CacheManager> cacheManagers = this.globalCacheManagerMap.get(tenantDomain);
        if (cacheManagers != null) {
            cacheManagers.remove(cacheManager.getName());
        }
    }

    public void removeAllCacheManagers(String tenantDomain) {
        Map<String, CacheManager> cacheManagers = this.globalCacheManagerMap.get(tenantDomain);
        if (cacheManagers != null) {
            for (CacheManager cacheManager : cacheManagers.values()) {
                if (!((CarbonCacheManager)cacheManager).removeLocalCaches()) continue;
                cacheManagers.remove(cacheManager.getName());
            }
        }
    }

    @Override
    public void removeCacheManagerMap(String tenantDomain) {
        this.globalCacheManagerMap.remove(tenantDomain);
    }

    private void ensureExpirySchedulerRunning() {
        if (this.cacheEvictionScheduler == null || this.cacheEvictionScheduler.isShutdown() || this.cacheEvictionScheduler.isTerminated()) {
            int threadCount = this.calculateExpiryThreadCount();
            this.cacheEvictionScheduler = Executors.newScheduledThreadPool(threadCount, threadFactory);
            this.cacheEvictionScheduler.scheduleWithFixedDelay(cacheCleanupTask, 30L, 30L, TimeUnit.SECONDS);
        }
    }

    private int calculateExpiryThreadCount() {
        int threadCount = Runtime.getRuntime().availableProcessors();
        if (threadCount < 1) {
            threadCount = 2;
        }
        return threadCount;
    }

    static {
        threadCount = 0;
        threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread th = new Thread(runnable);
                th.setName("CacheExpirySchedulerThread-" + threadCount++);
                return th;
            }
        };
    }
}

