/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistryConfig {
    public static final String FILE = "file";
    public static final String ITEM = "item";
    public static final String DUMP = "dump";
    public static final String COLLECTION = "collection";
    public static final String ASSOCIATION = "association";
    public static final String PATH = "path";
    public static final String DIRECTORY = "directory";
    public static final String SOURCE_PATH = "sourcePath";
    public static final String TARGET_PATH = "targetPath";
    public static final String TYPE = "type";
    public static final String REGISTRY_TYPE = "registry-type";
    public static final String MEDIA_TYPE = "mediaType";
    public static final String LOCAL_REGISTRY = "local";
    public static final String CONFIG_REGISTRY = "config";
    public static final String GOVERNANCE_REGISTRY = "governance";
    private Log log = LogFactory.getLog(RegistryConfig.class);
    private List<Resourse> resources = new ArrayList<Resourse>();
    private List<Dump> dumps = new ArrayList<Dump>();
    private List<Collection> collections = new ArrayList<Collection>();
    private List<Association> associations = new ArrayList<Association>();
    private String extractedPath;
    private String parentArtifactName;
    private String configFileName;
    private String appName;

    public void addResource(String path, String content, String regType, String mediaType) {
        if (path == null || path.length() == 0) {
            this.log.error((Object)"Resource path not found");
            return;
        }
        if (content == null || content.length() == 0) {
            this.log.error((Object)"Content name of the resource not found");
            return;
        }
        this.resources.add(new Resourse(path, content, regType, mediaType));
    }

    public List<Collection> getCollections() {
        return this.collections;
    }

    public void addDump(String path, String content, String regType) {
        if (path == null || path.length() == 0) {
            this.log.error((Object)"Dump path not found");
            return;
        }
        if (content == null || content.length() == 0) {
            this.log.error((Object)"Content name of the dump not found");
            return;
        }
        this.dumps.add(new Dump(path, content, regType));
    }

    public void addCollection(String path, String directory, String regType) {
        if (path == null || path.length() == 0) {
            this.log.error((Object)"Collection path not found");
            return;
        }
        if (directory == null || directory.length() == 0) {
            this.log.error((Object)"Directory name not found");
            return;
        }
        this.collections.add(new Collection(path, directory, regType));
    }

    public List<Association> getAssociations() {
        return this.associations;
    }

    public void addAssociation(String sourcePath, String targetPath, String assType, String regType) {
        if (sourcePath == null || sourcePath.length() == 0) {
            this.log.error((Object)"SourcePath of the association not found");
            return;
        }
        if (targetPath == null || targetPath.length() == 0) {
            this.log.error((Object)"TargetPath of the association not found");
            return;
        }
        if (assType == null || assType.length() == 0) {
            this.log.error((Object)"Type of the association not found");
            return;
        }
        this.associations.add(new Association(sourcePath, targetPath, assType, regType));
    }

    public List<Resourse> getResources() {
        return this.resources;
    }

    public List<Dump> getDumps() {
        return this.dumps;
    }

    public String getExtractedPath() {
        return this.extractedPath;
    }

    public void setExtractedPath(String extractedPath) {
        this.extractedPath = extractedPath;
    }

    public String getParentArtifactName() {
        return this.parentArtifactName;
    }

    public void setParentArtifactName(String parentArtifactName) {
        this.parentArtifactName = parentArtifactName;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void setConfigFileName(String configFileName) {
        this.configFileName = configFileName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public class Association {
        private String sourcePath;
        private String targetPath;
        private String associationType;
        private String registryType;

        public Association(String sourcePath, String targetPath, String assType, String regType) {
            this.sourcePath = sourcePath;
            this.targetPath = targetPath;
            this.associationType = assType;
            this.registryType = regType;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public String getAssociationType() {
            return this.associationType;
        }

        public String getRegistryType() {
            return this.registryType;
        }
    }

    public class Collection {
        private String path;
        private String directory;
        private String registryType;

        public Collection(String path, String directory, String regType) {
            this.path = path;
            this.directory = directory;
            this.registryType = regType;
        }

        public String getPath() {
            return this.path;
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getRegistryType() {
            return this.registryType;
        }
    }

    public class Dump {
        private String path;
        private String dumpFileName;
        private String registryType;

        public Dump(String path, String fileName, String regType) {
            this.path = path;
            this.dumpFileName = fileName;
            this.registryType = regType;
        }

        public String getPath() {
            return this.path;
        }

        public String getDumpFileName() {
            return this.dumpFileName;
        }

        public String getRegistryType() {
            return this.registryType;
        }
    }

    public class Resourse {
        private String path;
        private String fileName;
        private String registryType;
        private String mediaType;

        public Resourse(String path, String fileName, String regType, String mediaType) {
            this.path = path;
            this.fileName = fileName;
            this.registryType = regType;
            this.mediaType = mediaType;
        }

        public String getPath() {
            return this.path;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getRegistryType() {
            return this.registryType;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public String getMediaType() {
            return this.mediaType;
        }
    }
}

