/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.base;

import java.io.File;
import java.lang.management.ManagementPermission;
import java.util.List;
import java.util.Map;

public class CarbonBaseUtils {
    private CarbonBaseUtils() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static void checkSecurity() {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
    }

    public static void checkSecurity(List<String> allowedClasses) {
        StackTraceElement[] trace;
        String callingClass;
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null && !allowedClasses.contains(callingClass = (trace = Thread.currentThread().getStackTrace())[3].getClassName())) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
    }

    public static void checkSecurity(Map<String, String> allowedMethods) {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            for (int i = 3; i < trace.length; ++i) {
                String callingClass = trace[i].getClassName();
                String methodName = trace[i].getMethodName();
                if (!allowedMethods.keySet().contains(callingClass) || !allowedMethods.get(callingClass).equals(methodName)) continue;
                return;
            }
            secMan.checkPermission(new ManagementPermission("control"));
        }
    }

    public static String getServerXml() {
        String carbonXML = System.getProperty("carbon.config.dir.path");
        if (carbonXML == null) {
            return CarbonBaseUtils.getCarbonConfigDirPath() + File.separator + "carbon.xml";
        }
        return carbonXML + File.separator + "carbon.xml";
    }

    public static String getCarbonConfigDirPath() {
        String carbonConfigDirPath = System.getProperty("carbon.config.dir.path");
        if (carbonConfigDirPath == null && (carbonConfigDirPath = System.getenv("CARBON_CONFIG_DIR_PATH")) == null) {
            return CarbonBaseUtils.getCarbonHome() + File.separator + "repository" + File.separator + "conf";
        }
        return carbonConfigDirPath;
    }

    public static String getCarbonHome() {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
            System.setProperty("carbon.home", carbonHome);
        }
        return carbonHome;
    }
}

