/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.base.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.ServerConfigurationException;
import org.wso2.carbon.base.api.ServerConfigurationService;

public class CarbonBaseActivator
implements BundleActivator {
    private static Log log = LogFactory.getLog(CarbonBaseActivator.class);
    private ServiceRegistration registration;

    public void start(BundleContext bundleContext) throws Exception {
        ServerConfiguration carbonServerConfiguration = ServerConfiguration.getInstance();
        this.initServerConfiguration(carbonServerConfiguration);
        String portOffset = System.getProperty("portOffset", carbonServerConfiguration.getFirstProperty("Ports.Offset"));
        System.setProperty("portOffset", portOffset);
        this.registration = bundleContext.registerService(ServerConfigurationService.class.getName(), (Object)carbonServerConfiguration, null);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.registration.unregister();
    }

    private void initServerConfiguration(ServerConfiguration carbonServerConfiguration) throws ServletException {
        File carbonXML = new File(CarbonBaseUtils.getServerXml());
        FileInputStream in = null;
        try {
            in = new FileInputStream(carbonXML);
            carbonServerConfiguration.forceInit(in);
        }
        catch (ServerConfigurationException e) {
            String msg = "Could not initialize server configuration";
            log.fatal((Object)msg);
            throw new ServletException(msg);
        }
        catch (FileNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    log.warn((Object)("Cannot close FileInputStream of file " + carbonXML.getAbsolutePath()));
                }
            }
        }
    }
}

