/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class Bootstrap {
    private final Set<URL> classpath = new LinkedHashSet<URL>();
    private static final String CARBON_HOME = "carbon.home";
    private static final String INTERNAL_CARBON_LIB_DIR_PATH = "carbon.internal.lib.dir.path";
    protected static final String ROOT = System.getProperty("carbon.home", ".");
    private static final String CARBON_PROPERTIES = "carbon.properties";
    private static final String CONF_DIRECTORY_PATH = "carbon.config.dir.path";

    public static void main(String[] args) {
        new Bootstrap().loadClass(args);
    }

    protected final void loadClass(String[] args) {
        try {
            this.addSystemProperties();
            this.addClassPathEntries();
            URLClassLoader cl = new URLClassLoader(this.classpath.toArray(new URL[this.classpath.size()]));
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> appClass = cl.loadClass(this.getClassToLoad());
            Object app = appClass.newInstance();
            Method m = app.getClass().getMethod(this.getMethodToInvoke(), String[].class);
            m.invoke(app, new Object[]{args});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemProperties() {
        Properties properties = new Properties();
        String filePath = System.getProperty(CONF_DIRECTORY_PATH) + File.separator + CARBON_PROPERTIES;
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                properties.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            System.setProperty((String)key, (String)properties.get(key));
        }
    }

    protected void addClassPathEntries() throws MalformedURLException {
        String internalLib = System.getProperty(INTERNAL_CARBON_LIB_DIR_PATH);
        if (internalLib == null) {
            File libFile = Paths.get(ROOT, "lib").toFile();
            this.addFileUrl(libFile);
            this.addJarFileUrls(libFile);
        } else {
            this.addFileUrl(new File(internalLib));
            this.addJarFileUrls(new File(internalLib));
        }
    }

    protected final void addFileUrl(File file) throws MalformedURLException {
        this.classpath.add(file.toURI().toURL());
    }

    protected final void addJarFileUrls(File root) throws MalformedURLException {
        File[] children = root.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!child.isFile() || !child.canRead() || !child.getName().toLowerCase().endsWith(".jar")) continue;
            this.classpath.add(child.toURI().toURL());
        }
    }

    protected String getClassToLoad() {
        String serverMainClass = System.getProperty("server.main.class");
        if (serverMainClass != null) {
            return serverMainClass;
        }
        return "org.wso2.carbon.server.Main";
    }

    protected String getMethodToInvoke() {
        return "main";
    }
}

