/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.test;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class ParallelBatchP<T>
extends AbstractProcessor {
    private List<Traverser<T>> traversers;
    private final List<? extends Iterable<T>> iterables;

    public ParallelBatchP(List<? extends Iterable<T>> iterables) {
        this.iterables = iterables;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        int globalProcessorIndex = context.globalProcessorIndex();
        int totalParallelism = context.totalParallelism();
        this.traversers = IntStream.range(0, this.iterables.size()).filter(i -> i % totalParallelism == globalProcessorIndex).mapToObj(this.iterables::get).map(Traversers::traverseIterable).collect(Collectors.toList());
    }

    @Override
    public boolean complete() {
        boolean isCompleted = true;
        for (Traverser<T> traverser : this.traversers) {
            if (this.emitFromTraverser(traverser)) continue;
            isCompleted = false;
        }
        return isCompleted;
    }
}

