/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import java.util.concurrent.TimeUnit;

public final class ExpirationTimeSetter {
    private ExpirationTimeSetter() {
    }

    public static long nextExpirationTime(long ttlMillis, long maxIdleMillis, long now, long lastUpdateTime) {
        long nextTtlExpirationTime = ExpirationTimeSetter.nextTtlExpirationTime(ttlMillis, lastUpdateTime);
        long nextMaxIdleExpirationTime = ExpirationTimeSetter.nextMaxIdleExpirationTime(maxIdleMillis, now);
        return Math.min(nextTtlExpirationTime, nextMaxIdleExpirationTime);
    }

    private static long nextTtlExpirationTime(long ttlMillis, long lastUpdateTime) {
        return ExpirationTimeSetter.handleOverflow(ttlMillis + lastUpdateTime);
    }

    private static long nextMaxIdleExpirationTime(long maxIdleMillis, long now) {
        return ExpirationTimeSetter.handleOverflow(maxIdleMillis + now);
    }

    private static long handleOverflow(long time) {
        return time <= 0L ? Long.MAX_VALUE : time;
    }

    public static long pickTTLMillis(MapConfig mapConfig, long millisFromOperation) {
        return ExpirationTimeSetter.pickRightTimeInMillis(mapConfig.getTimeToLiveSeconds(), millisFromOperation);
    }

    public static long pickMaxIdleMillis(MapConfig mapConfig, long millisFromOperation) {
        return ExpirationTimeSetter.pickRightTimeInMillis(mapConfig.getMaxIdleSeconds(), millisFromOperation);
    }

    private static long pickRightTimeInMillis(int secondsFromMapConfig, long millisFromOperation) {
        if (millisFromOperation > 0L) {
            return millisFromOperation;
        }
        if (millisFromOperation == 0L) {
            return Long.MAX_VALUE;
        }
        if (secondsFromMapConfig > 0 && secondsFromMapConfig < Integer.MAX_VALUE) {
            return TimeUnit.SECONDS.toMillis(secondsFromMapConfig);
        }
        return Long.MAX_VALUE;
    }

    public static int toSeconds(long millis) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
        if (seconds == 0L && millis != 0L) {
            seconds = 1L;
        }
        return seconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)seconds;
    }

    public static long toMillis(int seconds) {
        return seconds == Integer.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.SECONDS.toMillis(seconds);
    }
}

