/*
*  Copyright (c) 2005-2011, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
*
*  WSO2 Inc. licenses this file to you under the Apache License,
*  Version 2.0 (the "License"); you may not use this file except
*  in compliance with the License.
*  You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/
package org.wso2.carbon.hazelcast;

/**
 * Constants used in Hazelcast based clustering implementation
 */
public final class HazelcastConstants {

    public static final String LOCAL_MEMBER_PORT = "localMemberPort";
    public static final String LOCAL_MEMBER_HOST = "localMemberHost";
    public static final String MGT_CENTER_URL = "mgtCenterURL";
    public static final String LICENSE_KEY = "licenseKey";
    public static final String CLUSTERING_MESSAGE_TOPIC = "$clustering.message.topic";
    public static final String CLUSTER_IDEMPOTENT_NON_RELIABLE_MESSAGE_TOPIC = "$carbon.idempotent.message.topic";
    public static final String GROUP_MGT_CMD_TOPIC = ".group.mgt.cmd.topic";
    public static final String CONTROL_COMMAND_TOPIC = "$control.$command.$topic";
    public static final String GROUP_PASSWORD = "groupPassword";

    public static final String REPLAY_MESSAGE_QUEUE = "$ReplayMessageQueue:";

    public static final String AWS_MEMBERSHIP_SCHEME = "aws";

    public static final String CLUSTER_COORDINATOR_LOCK = "$coordinator#@lock";

    public static final String CONFIG_XML_PATH_PROP = "hazelcast.config";

    public static final String CONFIG_XML_NAME = "hazelcast.xml";
    public static final String AWS_ECS_MEMBERSHIP_SCHEME = "aws-ecs";
    public static final String KUBERNETES_MEMBERSHIP_SCHEME = "kubernetes";

    private HazelcastConstants() {
    }
}
