/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.common.resolvers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ndatasource.common.resolvers.ResolverException;

public class FilePropertyLoader {
    private static final Log LOG = LogFactory.getLog(FilePropertyLoader.class);
    private static final String CONF_LOCATION = "conf.location";
    private static final String FILE_PROPERTY_PATH = "properties.file.path";
    private Map propertyMap;
    private static FilePropertyLoader fileLoaderInstance;

    public static FilePropertyLoader getInstance() {
        if (null == fileLoaderInstance) {
            fileLoaderInstance = new FilePropertyLoader();
            fileLoaderInstance.loadPropertiesFile();
        }
        return fileLoaderInstance;
    }

    public String getValue(String input) {
        return (String)this.propertyMap.get(input);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadPropertiesFile() {
        File file;
        boolean isFileExists;
        String filePath = System.getProperty(FILE_PROPERTY_PATH);
        if (null == filePath || filePath.isEmpty()) {
            throw new ResolverException("properties.file.path is empty or null");
        }
        if ("default".equals(filePath)) {
            filePath = System.getProperty(CONF_LOCATION) + File.separator + "file.properties";
        }
        if (!(isFileExists = (file = new File(filePath)).exists())) throw new ResolverException("File cannot found in " + filePath);
        try (FileInputStream in = new FileInputStream(filePath);){
            Properties rawProps = new Properties();
            this.propertyMap = new HashMap();
            rawProps.load(in);
            for (Map.Entry<Object, Object> propertyEntry : rawProps.entrySet()) {
                String strValue = (String)propertyEntry.getValue();
                this.propertyMap.put(propertyEntry.getKey(), strValue);
            }
            if (!LOG.isDebugEnabled()) return;
            LOG.debug((Object)("Loaded factory properties from " + filePath + ": " + this.propertyMap));
            return;
        }
        catch (IOException ex) {
            throw new ResolverException("Failed to read " + filePath, ex);
        }
    }
}

