/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.common.resolvers;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ndatasource.common.resolvers.DefaultResolver;
import org.wso2.carbon.ndatasource.common.resolvers.FilePropertyResolver;
import org.wso2.carbon.ndatasource.common.resolvers.Resolver;
import org.wso2.carbon.ndatasource.common.resolvers.ResolverException;
import org.wso2.carbon.ndatasource.common.resolvers.SystemResolver;

public class ResolverFactory {
    private static final int RESOLVER_INDEX = 2;
    private static ResolverFactory resolverFactory = new ResolverFactory();
    private final Pattern rePattern = Pattern.compile("(\\$)([a-zA-Z0-9]+):([_a-zA-Z0-9]+)");
    private static final Log log = LogFactory.getLog(ResolverFactory.class);
    private static final String SYSTEM_VARIABLE_PREFIX = "$SYSTEM";
    private static final String FILE_PROPERTY_VARIABLE_PREFIX = "$FILE";
    private Map<String, Class<? extends Resolver>> resolverMap = new HashMap<String, Class<? extends Resolver>>();

    public static ResolverFactory getInstance() {
        return resolverFactory;
    }

    private ResolverFactory() {
        this.registerResolvers();
        this.registerExterns();
    }

    public Resolver getResolver(String input) {
        Matcher matcher;
        if (input == null) {
            return null;
        }
        if (input.startsWith(SYSTEM_VARIABLE_PREFIX)) {
            matcher = this.rePattern.matcher(input);
            Resolver resolverObject = null;
            if (matcher.find()) {
                Class<? extends Resolver> resolverClass = this.resolverMap.get(matcher.group(2).toLowerCase());
                if (resolverClass != null) {
                    try {
                        resolverObject = resolverClass.newInstance();
                        resolverObject.setVariable(matcher.group(3));
                        return resolverObject;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new ResolverException("Resolver could not be found");
                    }
                }
                throw new ResolverException("Resolver could not be found");
            }
        } else if (input.startsWith(FILE_PROPERTY_VARIABLE_PREFIX)) {
            matcher = this.rePattern.matcher(input);
            Resolver resolverObject = null;
            if (matcher.find()) {
                Class<? extends Resolver> resolverClass = this.resolverMap.get(matcher.group(2).toLowerCase());
                if (resolverClass != null) {
                    try {
                        resolverObject = resolverClass.newInstance();
                        resolverObject.setVariable(matcher.group(3));
                        return resolverObject;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new ResolverException("Resolver could not be initialized", e);
                    }
                }
                throw new ResolverException("Resolver could not be found");
            }
        }
        DefaultResolver resolver = new DefaultResolver();
        resolver.setVariable(input);
        return resolver;
    }

    private void registerResolvers() {
        this.resolverMap.put("system", SystemResolver.class);
        this.resolverMap.put("file", FilePropertyResolver.class);
    }

    private void registerExterns() {
        ServiceLoader<Resolver> loaders = ServiceLoader.load(Resolver.class);
        for (Resolver resolver : loaders) {
            String className = resolver.getClass().getName();
            String[] packageList = className.split(".");
            if (this.resolverMap.get((className = packageList[packageList.length - 1]).toLowerCase()) == null) {
                this.resolverMap.put(className.toLowerCase(), resolver.getClass());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added Resolver " + className + " to resolver factory "));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Failed to Resolver " + className + " to resolver factory. Already exist"));
        }
    }
}

