/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.rdbms;

import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.xml.bind.JAXBContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.common.spi.DataSourceReader;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSource;
import org.wso2.carbon.utils.CarbonUtils;

public class RDBMSDataSourceReader
implements DataSourceReader {
    public String getType() {
        return "RDBMS";
    }

    public static RDBMSConfiguration loadConfig(String xmlConfiguration) throws DataSourceException {
        try {
            xmlConfiguration = CarbonUtils.replaceSystemVariablesInXml((String)xmlConfiguration);
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RDBMSConfiguration.class});
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(new StringReader(xmlConfiguration));
            return (RDBMSConfiguration)ctx.createUnmarshaller().unmarshal(xmlReader);
        }
        catch (Exception e) {
            throw new DataSourceException("Error in loading RDBMS configuration: " + e.getMessage(), e);
        }
    }

    public Object createDataSource(String xmlConfiguration, boolean isDataSourceFactoryReference) throws DataSourceException {
        if (isDataSourceFactoryReference) {
            return new RDBMSDataSource(RDBMSDataSourceReader.loadConfig(xmlConfiguration)).getDataSourceFactoryReference();
        }
        return new RDBMSDataSource(RDBMSDataSourceReader.loadConfig(xmlConfiguration)).getDataSource();
    }

    public boolean testDataSourceConnection(String xmlConfiguration) throws DataSourceException {
        RDBMSConfiguration rdbmsConfiguration = RDBMSDataSourceReader.loadConfig(xmlConfiguration);
        DataSource dataSource = new RDBMSDataSource(rdbmsConfiguration).getDataSource();
        Connection connection = null;
        try {
            Class.forName(rdbmsConfiguration.getDriverClassName());
            if (rdbmsConfiguration.getUsername() != null) {
                DriverManager.getConnection(rdbmsConfiguration.getUrl(), rdbmsConfiguration.getUsername(), rdbmsConfiguration.getPassword());
            } else {
                DriverManager.getConnection(rdbmsConfiguration.getUrl());
            }
        }
        catch (ClassNotFoundException e) {
            throw new DataSourceException("Error loading Driver class:" + e.getMessage(), (Exception)e);
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("08001")) {
                throw new DataSourceException("The data source URL is not accepted by any of the loaded drivers. " + e.getMessage(), (Exception)e);
            }
            if (e.getSQLState().equals("28000")) {
                throw new DataSourceException("The user is not associated with a trusted SQL Server connection." + e.getMessage(), (Exception)e);
            }
            throw new DataSourceException("Error establishing data source connection: " + e.getMessage(), (Exception)e);
        }
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new DataSourceException("Error establishing data source connection: " + e.getMessage(), (Exception)e);
        }
        if (connection != null) {
            String validationQuery = rdbmsConfiguration.getValidationQuery();
            if (validationQuery != null && !"".equals(validationQuery)) {
                try (PreparedStatement ps = connection.prepareStatement(validationQuery.trim());){
                    ps.execute();
                }
                catch (SQLException e) {
                    throw new DataSourceException("Error during executing validation query: " + e.getMessage(), (Exception)e);
                }
            }
            try {
                connection.close();
            }
            catch (SQLException ignored) {
                // empty catch block
            }
        }
        return true;
    }
}

