/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.rdbms;

import java.lang.management.ManagementFactory;
import java.sql.SQLException;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.utils.RDBMSDataSourceUtils;

public class RDBMSDataSource {
    private static Log log = LogFactory.getLog(RDBMSDataSource.class);
    private DataSource dataSource;
    private Reference dataSourceFactoryReference;
    private PoolConfiguration poolProperties;

    public RDBMSDataSource(RDBMSConfiguration config) throws DataSourceException {
        this.poolProperties = RDBMSDataSourceUtils.createPoolConfiguration(config);
        this.populateStandardProps();
    }

    private void populateStandardProps() {
        String jdbcInterceptors = this.poolProperties.getJdbcInterceptors();
        if (jdbcInterceptors == null) {
            jdbcInterceptors = "";
        }
        jdbcInterceptors = "ConnectionState;StatementFinalizer;" + jdbcInterceptors;
        this.poolProperties.setJdbcInterceptors(jdbcInterceptors);
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new DataSource(this.poolProperties);
        }
        if (this.poolProperties.isJmxEnabled()) {
            this.registerMBean();
        }
        return this.dataSource;
    }

    private void registerMBean() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        String mBean = "";
        try {
            if (DataSourceUtils.getCurrentDataSourceId() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The current dataSource id is not set");
                }
                return;
            }
            String[] dataSourceId = DataSourceUtils.getCurrentDataSourceId().split(":");
            mBean = dataSourceId[1] + "," + dataSourceId[0];
            ObjectName objectName = new ObjectName(mBean + ":type=DataSource");
            mBeanServer.registerMBean(this.dataSource.createPool().getJmxPool(), objectName);
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)("Error while registering the MBean for dataSource '" + mBean + " " + e.getMessage()), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error((Object)("Error while registering the MBean for dataSource '" + mBean + " " + e.getMessage()), (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)("Error while registering the MBean for dataSource '" + mBean + " " + e.getMessage()), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error((Object)("Error while registering the MBean for dataSource '" + mBean + " " + e.getMessage()), (Throwable)e);
        }
    }

    public Reference getDataSourceFactoryReference() throws DataSourceException {
        if (this.dataSourceFactoryReference == null) {
            this.dataSourceFactoryReference = new Reference("org.apache.tomcat.jdbc.pool.DataSource", "org.apache.tomcat.jdbc.pool.DataSourceFactory", null);
            Map<String, String> poolConfigMap = RDBMSDataSourceUtils.extractPrimitiveFieldNameValuePairs(this.poolProperties);
            for (Map.Entry<String, String> pairs : poolConfigMap.entrySet()) {
                this.dataSourceFactoryReference.add(new StringRefAddr(pairs.getKey(), pairs.getValue()));
            }
        }
        return this.dataSourceFactoryReference;
    }
}

