/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.rdbms.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.common.resolvers.ResolverFactory;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSourceConstants;

public class RDBMSDataSourceUtils {
    public static void assignBeanProps(Object obj, Map<String, Object> props) throws DataSourceException {
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Method method = RDBMSDataSourceUtils.getSetterMethod(obj, RDBMSDataSourceUtils.getSetterMethodNameFromPropName(prop.getKey()));
            if (method == null) {
                throw new DataSourceException("Setter method for property '" + prop.getKey() + "' cannot be found");
            }
            try {
                method.invoke(obj, RDBMSDataSourceUtils.convertStringToGivenType(prop.getValue(), method.getParameterTypes()[0]));
            }
            catch (Exception e) {
                throw new DataSourceException("Cannot invoke setter for property '" + prop.getKey() + "'", e);
            }
        }
    }

    private static Object convertStringToGivenType(Object value, Class<?> type) throws DataSourceException {
        if (String.class.equals(type) || Properties.class.equals(type)) {
            return value;
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return Boolean.parseBoolean(String.valueOf(value));
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return Integer.parseInt(String.valueOf(value));
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return Short.parseShort(String.valueOf(value));
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return Byte.parseByte(String.valueOf(value));
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return Long.parseLong(String.valueOf(value));
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return Float.valueOf(Float.parseFloat(String.valueOf(value)));
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return Double.parseDouble(String.valueOf(value));
        }
        throw new DataSourceException("Cannot convert value: '" + value + "' to type: '" + type.getName() + "'");
    }

    public static boolean isEmptyString(String text) {
        return text == null || text.trim().length() <= 0;
    }

    private static String getSetterMethodNameFromPropName(String propName) throws RuntimeException {
        if (RDBMSDataSourceUtils.isEmptyString(propName)) {
            throw new RuntimeException("Invalid property name");
        }
        return "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
    }

    private static Method getSetterMethod(Object obj, String name) {
        Method[] methods;
        for (Method method : methods = obj.getClass().getMethods()) {
            if (!method.getName().equals(name) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    public static Map<String, String> extractPrimitiveFieldNameValuePairs(Object object) throws DataSourceException {
        Method[] methods;
        HashMap<String, String> nameValueMap = new HashMap<String, String>();
        for (Method method : methods = object.getClass().getMethods()) {
            if (!RDBMSDataSourceUtils.isMethodMatched(method)) continue;
            String FieldName = RDBMSDataSourceUtils.getFieldNameFromMethodName(method.getName());
            String result = null;
            try {
                if (method.invoke(object, new Object[0]) == null) continue;
                result = method.invoke(object, new Object[0]).toString();
                nameValueMap.put(FieldName, result);
            }
            catch (Exception e) {
                throw new DataSourceException("Error in retrieving " + FieldName + " value from the object :" + object.getClass() + e.getMessage(), e);
            }
        }
        return nameValueMap;
    }

    private static String getFieldNameFromMethodName(String name) throws DataSourceException {
        String prefixGet = "get";
        String prefixIs = "is";
        String firstLetter = null;
        if (name.startsWith(prefixGet)) {
            firstLetter = name.substring(3, 4);
            name = name.substring(4);
        } else if (name.startsWith(prefixIs)) {
            firstLetter = name.substring(2, 3);
            name = name.substring(3);
        } else {
            throw new DataSourceException("Error in retrieving attribute name from method : " + name);
        }
        firstLetter = firstLetter.toLowerCase();
        return firstLetter.concat(name);
    }

    private static boolean isMethodMatched(Method method) {
        String returnType = method.getReturnType().getSimpleName();
        String methodName = method.getName();
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (returnType.equals("void")) {
            return false;
        }
        if (!(methodName.startsWith("get") || methodName.startsWith("is") && (returnType.equals("Boolean") || returnType.equals("boolean")))) {
            return false;
        }
        return method.getReturnType().isPrimitive() || Arrays.asList(RDBMSDataSourceConstants.CLASS_RETURN_TYPES).contains(returnType);
    }

    public static PoolConfiguration createPoolConfiguration(RDBMSConfiguration config) throws DataSourceException {
        String isolationLevelString;
        PoolProperties props = new PoolProperties();
        String resolvedUrl = null;
        if (config.getUrl() != null) {
            resolvedUrl = ResolverFactory.getInstance().getResolver(config.getUrl()).resolve();
        }
        props.setUrl(resolvedUrl);
        if (config.isDefaultAutoCommit() != null) {
            props.setDefaultAutoCommit(config.isDefaultAutoCommit());
        }
        if (config.isDefaultReadOnly() != null) {
            props.setDefaultReadOnly(config.isDefaultReadOnly());
        }
        if ((isolationLevelString = config.getDefaultTransactionIsolation()) != null) {
            if ("NONE".equals(isolationLevelString)) {
                props.setDefaultTransactionIsolation(0);
            } else if ("READ_UNCOMMITTED".equals(isolationLevelString)) {
                props.setDefaultTransactionIsolation(1);
            } else if ("READ_COMMITTED".equals(isolationLevelString)) {
                props.setDefaultTransactionIsolation(2);
            } else if ("REPEATABLE_READ".equals(isolationLevelString)) {
                props.setDefaultTransactionIsolation(4);
            } else if ("SERIALIZABLE".equals(isolationLevelString)) {
                props.setDefaultTransactionIsolation(8);
            }
        }
        props.setDefaultCatalog(config.getDefaultCatalog());
        String resolvedDriver = null;
        if (config.getDriverClassName() != null) {
            resolvedDriver = ResolverFactory.getInstance().getResolver(config.getDriverClassName()).resolve();
        }
        props.setDriverClassName(resolvedDriver);
        String username = config.getUsername();
        String resolvedUsername = null;
        if (username != null) {
            resolvedUsername = ResolverFactory.getInstance().getResolver(username).resolve();
        }
        if (null != resolvedUsername && !"".equals(resolvedUsername)) {
            props.setUsername(resolvedUsername);
            String password = config.getPassword();
            String resolvedPassword = null;
            if (password != null) {
                resolvedPassword = ResolverFactory.getInstance().getResolver(password).resolve();
            }
            if (null != resolvedPassword && !"".equals(resolvedPassword)) {
                props.setPassword(resolvedPassword);
            }
        }
        if (config.getMaxActive() != null) {
            props.setMaxActive(config.getMaxActive().intValue());
        }
        if (config.getMaxIdle() != null) {
            props.setMaxIdle(config.getMaxIdle().intValue());
        }
        if (config.getMinIdle() != null) {
            props.setMinIdle(config.getMinIdle().intValue());
        }
        if (config.getInitialSize() != null) {
            props.setInitialSize(config.getInitialSize().intValue());
        }
        if (config.getMaxWait() != null) {
            props.setMaxWait(config.getMaxWait().intValue());
        }
        if (config.isTestOnBorrow() != null) {
            props.setTestOnBorrow(config.isTestOnBorrow().booleanValue());
        }
        if (config.isTestOnReturn() != null) {
            props.setTestOnReturn(config.isTestOnReturn().booleanValue());
        }
        if (config.isTestWhileIdle() != null) {
            props.setTestWhileIdle(config.isTestWhileIdle().booleanValue());
        }
        props.setValidationQuery(config.getValidationQuery());
        props.setValidatorClassName(config.getValidatorClassName());
        if (config.getTimeBetweenEvictionRunsMillis() != null) {
            props.setTimeBetweenEvictionRunsMillis(config.getTimeBetweenEvictionRunsMillis().intValue());
        }
        if (config.getNumTestsPerEvictionRun() != null) {
            props.setNumTestsPerEvictionRun(config.getNumTestsPerEvictionRun().intValue());
        }
        if (config.getMinEvictableIdleTimeMillis() != null) {
            props.setMinEvictableIdleTimeMillis(config.getMinEvictableIdleTimeMillis().intValue());
        }
        if (config.isAccessToUnderlyingConnectionAllowed() != null) {
            props.setAccessToUnderlyingConnectionAllowed(config.isAccessToUnderlyingConnectionAllowed().booleanValue());
        }
        if (config.isRemoveAbandoned() != null) {
            props.setRemoveAbandoned(config.isRemoveAbandoned().booleanValue());
        }
        if (config.getRemoveAbandonedTimeout() != null) {
            props.setRemoveAbandonedTimeout(config.getRemoveAbandonedTimeout().intValue());
        }
        if (config.isLogAbandoned() != null) {
            props.setLogAbandoned(config.isLogAbandoned().booleanValue());
        }
        props.setConnectionProperties(config.getConnectionProperties());
        props.setInitSQL(config.getInitSQL());
        props.setJdbcInterceptors(config.getJdbcInterceptors());
        if (config.getValidationInterval() != null) {
            props.setValidationInterval(config.getValidationInterval().longValue());
        }
        props.setJmxEnabled(config.isJmxEnabled() == null ? false : config.isJmxEnabled());
        if (config.isFairQueue() != null) {
            props.setFairQueue(config.isFairQueue().booleanValue());
        }
        if (config.getAbandonWhenPercentageFull() != null) {
            props.setAbandonWhenPercentageFull(config.getAbandonWhenPercentageFull().intValue());
        }
        if (config.getMaxAge() != null) {
            props.setMaxAge(config.getMaxAge().longValue());
        }
        if (config.isUseEquals() != null) {
            props.setUseEquals(config.isUseEquals().booleanValue());
        }
        if (config.getSuspectTimeout() != null) {
            props.setSuspectTimeout(config.getSuspectTimeout().intValue());
        }
        if (config.getValidationQueryTimeout() != null) {
            props.setValidationQueryTimeout(config.getValidationQueryTimeout().intValue());
        }
        if (config.isAlternateUsernameAllowed() != null) {
            props.setAlternateUsernameAllowed(config.isAlternateUsernameAllowed().booleanValue());
        }
        if (config.getCommitOnReturn() != null) {
            props.setCommitOnReturn(config.getCommitOnReturn().booleanValue());
        }
        if (config.getRollbackOnReturn() != null) {
            props.setRollbackOnReturn(config.getRollbackOnReturn().booleanValue());
        }
        if (config.getDataSourceClassName() != null) {
            RDBMSDataSourceUtils.handleExternalDataSource(props, config);
        }
        if (config.getDatabaseProps() != null) {
            Properties properties = new Properties();
            if (!config.getDatabaseProps().isEmpty()) {
                for (RDBMSConfiguration.DataSourceProperty property : config.getDatabaseProps()) {
                    properties.setProperty(property.getName(), property.getValue());
                }
            }
            props.setDbProperties(properties);
        }
        return props;
    }

    private static Map<String, Object> dataSourcePropsToMap(List<RDBMSConfiguration.DataSourceProperty> dsProps) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (dsProps != null) {
            HashMap<String, Properties> tmpPropertiesObjects = new HashMap<String, Properties>();
            for (RDBMSConfiguration.DataSourceProperty dsProp : dsProps) {
                String[] prop = dsProp.getName().split("\\.");
                if (prop.length > 1) {
                    Properties tmpProp;
                    if (!tmpPropertiesObjects.containsKey(prop[0])) {
                        tmpProp = new Properties();
                        tmpPropertiesObjects.put(prop[0], tmpProp);
                    } else {
                        tmpProp = (Properties)tmpPropertiesObjects.get(prop[0]);
                    }
                    tmpProp.setProperty(prop[1], dsProp.getValue());
                    continue;
                }
                result.put(dsProp.getName(), dsProp.getValue());
            }
            result.putAll(tmpPropertiesObjects);
        }
        return result;
    }

    private static void handleExternalDataSource(PoolProperties poolProps, RDBMSConfiguration config) throws DataSourceException {
        String dsClassName = config.getDataSourceClassName();
        try {
            Object extDataSource = Class.forName(dsClassName).newInstance();
            RDBMSDataSourceUtils.assignBeanProps(extDataSource, RDBMSDataSourceUtils.dataSourcePropsToMap(config.getDataSourceProps()));
            poolProps.setDataSource(extDataSource);
        }
        catch (Exception e) {
            throw new DataSourceException("Error in creating external data source: " + e.getMessage(), e);
        }
    }
}

