/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.rdbms;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.interceptor.AbstractQueryReport;
import org.wso2.carbon.utils.xml.StringUtils;

public class CorrelationLogInterceptor
extends AbstractQueryReport {
    private static final Log correlationLog = LogFactory.getLog((String)"correlation");
    private static final Log log = LogFactory.getLog(CorrelationLogInterceptor.class);
    private static final String CORRELATION_LOG_CALL_TYPE_VALUE = "jdbc";
    private static final String CORRELATION_LOG_SEPARATOR = "|";
    private static final String CORRELATION_LOG_SYSTEM_PROPERTY = "enableCorrelationLogs";
    private static final String BLACKLISTED_THREADS_SYSTEM_PROPERTY = "org.wso2.CorrelationLogInterceptor.BlacklistedThreads";
    private static final String[] DEFAULT_BLACKLISTED_THREADS = new String[]{"MessageDeliveryTaskThreadPool", "HumanTaskServer", "BPELServer", "CarbonDeploymentSchedulerThread"};
    private List<String> blacklistedThreadList = new ArrayList<String>();
    private boolean isEnableCorrelationLogs;

    public CorrelationLogInterceptor() {
        String blacklistedThreadNames = System.getProperty(BLACKLISTED_THREADS_SYSTEM_PROPERTY);
        if (blacklistedThreadNames == null) {
            this.blacklistedThreadList.addAll(Arrays.asList(DEFAULT_BLACKLISTED_THREADS));
        }
        if (!StringUtils.isEmpty((String)blacklistedThreadNames)) {
            this.blacklistedThreadList.addAll(Arrays.asList(StringUtils.split((String)blacklistedThreadNames, (char)',')));
        }
        this.isEnableCorrelationLogs = Boolean.parseBoolean(System.getProperty(CORRELATION_LOG_SYSTEM_PROPERTY));
    }

    public void closeInvoked() {
    }

    protected void prepareStatement(String s, long l) {
    }

    protected void prepareCall(String s, long l) {
    }

    public Object createStatement(Object proxy, Method method, Object[] args, Object statement, long time) {
        try {
            if (this.isEnableCorrelationLogs) {
                return this.invokeProxy(method, args, statement, time);
            }
            return statement;
        }
        catch (Exception e) {
            log.error((Object)"Unable to create statement proxy for slow query report.", (Throwable)e);
            return statement;
        }
    }

    private Object invokeProxy(Method method, Object[] args, Object statement, long time) throws Exception {
        String name = method.getName();
        String sql = null;
        Constructor constructor = null;
        if (this.compare("prepareStatement", name)) {
            sql = (String)args[0];
            constructor = this.getConstructor(1, PreparedStatement.class);
            if (sql != null) {
                this.prepareStatement(sql, time);
            }
        } else if (this.compare("prepareCall", name)) {
            sql = (String)args[0];
            constructor = this.getConstructor(2, CallableStatement.class);
            this.prepareCall(sql, time);
        } else {
            return statement;
        }
        if (constructor != null) {
            return constructor.newInstance(new StatementProxy(statement, sql));
        }
        return null;
    }

    protected class StatementProxy
    implements InvocationHandler {
        protected boolean closed = false;
        protected Object delegate;
        protected final String query;

        public StatementProxy(Object parent, String query) {
            this.delegate = parent;
            this.query = query;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            boolean close = CorrelationLogInterceptor.this.compare("close", name);
            if (close && this.closed) {
                return null;
            }
            if (CorrelationLogInterceptor.this.compare("isClosed", name)) {
                return this.closed;
            }
            if (this.closed) {
                throw new SQLException("Statement closed.");
            }
            boolean process = CorrelationLogInterceptor.this.isExecute(method, false);
            long start = System.currentTimeMillis();
            Object result = null;
            if (this.delegate != null) {
                result = method.invoke(this.delegate, args);
            }
            if (process) {
                long delta = System.currentTimeMillis() - start;
                CorrelationLogInterceptor.this.reportQuery(this.query, args, name, start, delta);
                this.logQueryDetails(start, delta, name);
            }
            if (close) {
                this.closed = true;
                this.delegate = null;
            }
            return result;
        }

        private void logQueryDetails(long start, long delta, String methodName) throws SQLException {
            if (!(this.delegate instanceof PreparedStatement)) {
                return;
            }
            PreparedStatement preparedStatement = (PreparedStatement)this.delegate;
            if (preparedStatement.getConnection() == null) {
                return;
            }
            if (this.isCurrentThreadBlacklisted()) {
                return;
            }
            DatabaseMetaData metaData = preparedStatement.getConnection().getMetaData();
            if (correlationLog.isInfoEnabled()) {
                ArrayList<String> logPropertiesList = new ArrayList<String>();
                logPropertiesList.add(Long.toString(delta));
                logPropertiesList.add(CorrelationLogInterceptor.CORRELATION_LOG_CALL_TYPE_VALUE);
                logPropertiesList.add(Long.toString(start));
                logPropertiesList.add(methodName);
                logPropertiesList.add(this.query);
                logPropertiesList.add(metaData.getURL());
                correlationLog.info((Object)this.createFormattedLog(logPropertiesList));
            }
        }

        private boolean isCurrentThreadBlacklisted() {
            String threadName = Thread.currentThread().getName();
            for (String thread : CorrelationLogInterceptor.this.blacklistedThreadList) {
                if (!threadName.startsWith(thread)) continue;
                return true;
            }
            return false;
        }

        private String createFormattedLog(List<String> logPropertiesList) {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (String property : logPropertiesList) {
                sb.append(property);
                if (count < logPropertiesList.size() - 1) {
                    sb.append(CorrelationLogInterceptor.CORRELATION_LOG_SEPARATOR);
                }
                ++count;
            }
            return sb.toString();
        }
    }
}

