/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.roles.mgt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.roles.mgt.ServerRoleConstants;

public final class ServerRoleUtils {
    private ServerRoleUtils() {
    }

    public static List<String> readProductServerRoles() {
        String[] serverRoles;
        String temp = System.getProperty("serverRoles");
        if (temp != null) {
            serverRoles = temp.split(",");
        } else {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            serverRoles = serverConfig.getProperties("ServerRoles.Role");
        }
        return ServerRoleUtils.arrayToList(serverRoles);
    }

    public static String[] listToArray(List<String> list) {
        if (list != null && !list.isEmpty()) {
            String[] array = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = list.get(i);
            }
            return array;
        }
        return null;
    }

    public static List<String> arrayToList(String[] array) {
        if (array != null && array.length != 0) {
            return Arrays.asList(array);
        }
        return null;
    }

    public static List<String> mergeLists(List<String> targetList, List<String> itemsList) {
        List<String> returnList = null;
        if (itemsList != null && !itemsList.isEmpty()) {
            if (targetList != null && !targetList.isEmpty()) {
                HashSet<String> targetSet = new HashSet<String>(targetList);
                targetSet.addAll(itemsList);
                returnList = new ArrayList<String>(targetSet);
            } else {
                returnList = itemsList;
            }
        } else if (targetList != null && !targetList.isEmpty()) {
            returnList = targetList;
        }
        return returnList;
    }

    public static String getRegistryPath(String serverRoleType) {
        if ("Default".equals(serverRoleType)) {
            return ServerRoleConstants.DEFAULT_ROLES_PATH;
        }
        if ("Custom".equals(serverRoleType)) {
            return ServerRoleConstants.CUSTOM_ROLES_PATH;
        }
        return null;
    }
}

