/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.roles.mgt;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.roles.mgt.ServerRoleUtils;
import org.wso2.carbon.roles.mgt.ServerRolesException;
import org.wso2.carbon.roles.mgt.ServerRolesManagerService;

public class ServerRolesManager
extends AbstractAdmin
implements ServerRolesManagerService {
    private static final Log log = LogFactory.getLog(ServerRolesManager.class);

    @Override
    public String[] readServerRoles(String serverRoleType) throws ServerRolesException {
        log.debug((Object)("Reading " + serverRoleType + " Server-Roles from Registry."));
        Registry configReg = this.getConfigSystemRegistry();
        String regPath = this.getRegistryPath(serverRoleType);
        Resource resource = this.getResourceFromRegistry(configReg, regPath);
        if ("Default".equals(serverRoleType)) {
            List<String> productServerRolesList = ServerRoleUtils.readProductServerRoles();
            if (resource == null) {
                try {
                    resource = configReg.newResource();
                    resource.setProperty(serverRoleType, productServerRolesList);
                    resource.setProperty("modified", "false");
                    this.putResourceToRegistry(configReg, resource, regPath);
                }
                catch (RegistryException e) {
                    this.handleException(e.getMessage(), (Exception)((Object)e));
                }
            } else {
                String modified = resource.getProperty("modified");
                if (modified == null || "false".equals(modified)) {
                    resource.setProperty(serverRoleType, productServerRolesList);
                    resource.setProperty("modified", "false");
                    this.putResourceToRegistry(configReg, resource, regPath);
                }
            }
        }
        String[] serverRolesArray = null;
        if (resource != null) {
            List serverRolesList = resource.getPropertyValues(serverRoleType);
            serverRolesArray = ServerRoleUtils.listToArray(serverRolesList);
        }
        if (serverRolesArray == null) {
            serverRolesArray = new String[]{};
        }
        return serverRolesArray;
    }

    @Override
    public boolean removeServerRoles(String[] serverRolesArray, String serverRoleType) throws ServerRolesException {
        boolean isRemoved;
        Resource resource;
        List serverRolesList;
        log.debug((Object)("Removing " + serverRoleType + " Server-Roles from Registry."));
        boolean status = false;
        Registry configReg = this.getConfigSystemRegistry();
        String regPath = this.getRegistryPath(serverRoleType);
        List<String> serverRolesListToRemove = ServerRoleUtils.arrayToList(serverRolesArray);
        if (serverRolesArray != null && serverRolesArray.length != 0 && (serverRolesList = (resource = this.getResourceFromRegistry(configReg, regPath)).getPropertyValues(serverRoleType)) != null && !serverRolesList.isEmpty() && (isRemoved = serverRolesList.removeAll(serverRolesListToRemove))) {
            resource.setProperty(serverRoleType, serverRolesList);
            if ("Default".equals(serverRoleType)) {
                resource.setProperty("modified", "true");
            }
            this.putResourceToRegistry(configReg, resource, regPath);
            status = true;
        }
        return status;
    }

    @Override
    public boolean addServerRoles(String[] serverRolesArray, String serverRoleType) throws ServerRolesException {
        log.debug((Object)("Adding " + serverRoleType + " Server-Roles to Registry."));
        boolean status = false;
        Registry configReg = this.getConfigSystemRegistry();
        String regPath = this.getRegistryPath(serverRoleType);
        if (serverRolesArray != null && serverRolesArray.length != 0) {
            List<String> serverRolesListToAdd = ServerRoleUtils.arrayToList(serverRolesArray);
            Resource resource = this.getResourceFromRegistry(configReg, regPath);
            if (resource == null) {
                try {
                    resource = configReg.newResource();
                    resource.setProperty(serverRoleType, serverRolesListToAdd);
                }
                catch (RegistryException e) {
                    this.handleException(e.getMessage(), (Exception)((Object)e));
                }
            } else {
                List<String> serverRolesList = resource.getPropertyValues(serverRoleType);
                serverRolesList = ServerRoleUtils.mergeLists(serverRolesList, serverRolesListToAdd);
                resource.setProperty(serverRoleType, serverRolesList);
                status = true;
            }
            this.putResourceToRegistry(configReg, resource, regPath);
            String defaultPath = this.getRegistryPath("Default");
            Resource defaultResource = this.getResourceFromRegistry(configReg, defaultPath);
            if (defaultResource != null) {
                defaultResource.setProperty("modified", "true");
            }
            this.putResourceToRegistry(configReg, defaultResource, defaultPath);
        }
        return status;
    }

    private Resource getResourceFromRegistry(Registry configReg, String serverRolesPath) throws ServerRolesException {
        Resource serverRolesResource = null;
        try {
            if (configReg.resourceExists(serverRolesPath)) {
                serverRolesResource = configReg.get(serverRolesPath);
            }
        }
        catch (RegistryException e) {
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
        return serverRolesResource;
    }

    private void putResourceToRegistry(Registry configReg, Resource serverRolesResource, String serverRolesPath) throws ServerRolesException {
        try {
            if (configReg.resourceExists(serverRolesPath)) {
                configReg.delete(serverRolesPath);
            }
            configReg.put(serverRolesPath, serverRolesResource);
        }
        catch (RegistryException e) {
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void handleException(String message, Exception e) throws ServerRolesException {
        log.error((Object)message, (Throwable)e);
        throw new ServerRolesException(message, e);
    }

    private void handleException(String message) throws ServerRolesException {
        log.error((Object)message);
        throw new ServerRolesException(message);
    }

    private String getRegistryPath(String serverRoleType) throws ServerRolesException {
        String path = ServerRoleUtils.getRegistryPath(serverRoleType);
        if (path == null) {
            this.handleException("Undefined Server Roles Type.");
        }
        return path;
    }
}

