/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.scan;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;

public class CarbonTomcatJarScanner
extends StandardJarScanner {
    private static final Log log = LogFactory.getLog(CarbonTomcatJarScanner.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.scan");
    private static final String CARBON_PLUGINS_DIR_PATH;

    protected void doScanClassPath(JarScanType scanType, ServletContext context, JarScannerCallback callback, Set<URL> processedURLs) {
        super.doScanClassPath(scanType, context, callback, processedURLs);
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("wso2.jarScan.classloaderStart"));
        }
        ClassLoader stopLoader = null;
        if (!this.isScanBootstrapClassPath()) {
            stopLoader = ClassLoader.getSystemClassLoader().getParent();
        }
        ModuleClassLoader moduleClassloader = null;
        for (ClassLoader classLoader = context.getClassLoader(); classLoader != null && classLoader != stopLoader; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof ModuleClassLoader)) continue;
            moduleClassloader = (ModuleClassLoader)classLoader;
            break;
        }
        if (moduleClassloader == null) {
            return;
        }
        LinkedList<URL> classPathUrlsToProcess = new LinkedList<URL>();
        File pluginsDir = new File(CARBON_PLUGINS_DIR_PATH);
        File[] files = pluginsDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".jar")) continue;
            try {
                classPathUrlsToProcess.add(files[0].toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.processURLs(scanType, callback, processedURLs, false, classPathUrlsToProcess);
    }

    static {
        String pluginsPath = System.getProperty("components.repo");
        CARBON_PLUGINS_DIR_PATH = pluginsPath == null ? Paths.get(System.getProperty("carbon.home"), "repository", "components", "plugins").toString() : pluginsPath;
    }
}

