/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.transport;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.coyote.Response;
import org.wso2.carbon.core.SameSiteCookie;
import org.wso2.carbon.core.ServletCookie;
import org.wso2.carbon.tomcat.ext.transport.ResponseFacadeWrapper;

public class CarbonResponseWrapper
extends org.apache.catalina.connector.Response {
    private org.apache.catalina.connector.Response wrapped;
    private ResponseFacadeWrapper responseFacadeWrapper;

    public CarbonResponseWrapper(org.apache.catalina.connector.Response wrapped) {
        this.wrapped = wrapped;
    }

    public org.apache.catalina.connector.Response getWrapped() {
        return this.wrapped;
    }

    public String generateCookieString(Cookie cookie) {
        String cookieString = super.generateCookieString(cookie);
        cookieString = cookie instanceof ServletCookie ? cookieString + "; SameSite=" + ((ServletCookie)cookie).getSameSite().getName() : cookieString + "; SameSite=" + SameSiteCookie.STRICT.getName();
        return cookieString;
    }

    public void setCoyoteResponse(Response coyoteResponse) {
        this.wrapped.setCoyoteResponse(coyoteResponse);
    }

    public Response getCoyoteResponse() {
        return this.wrapped.getCoyoteResponse();
    }

    public Context getContext() {
        return this.wrapped.getContext();
    }

    public void recycle() {
        this.wrapped.recycle();
    }

    public List<Cookie> getCookies() {
        return this.wrapped.getCookies();
    }

    public long getContentWritten() {
        return this.wrapped.getContentWritten();
    }

    public long getBytesWritten(boolean flush) {
        return this.wrapped.getBytesWritten(flush);
    }

    public void setAppCommitted(boolean appCommitted) {
        this.wrapped.setAppCommitted(appCommitted);
    }

    public boolean isAppCommitted() {
        return this.wrapped.isAppCommitted();
    }

    public Request getRequest() {
        return this.wrapped.getRequest();
    }

    public void setRequest(Request request) {
        this.wrapped.setRequest(request);
    }

    public HttpServletResponse getResponse() {
        if (this.responseFacadeWrapper == null) {
            this.responseFacadeWrapper = new ResponseFacadeWrapper(this);
        }
        return this.responseFacadeWrapper;
    }

    public void setResponse(HttpServletResponse applicationResponse) {
        this.wrapped.setResponse(applicationResponse);
    }

    public void setSuspended(boolean suspended) {
        this.wrapped.setSuspended(suspended);
    }

    public boolean isSuspended() {
        return this.wrapped.isSuspended();
    }

    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    public boolean setError() {
        return this.wrapped.setError();
    }

    public boolean isError() {
        return this.wrapped.isError();
    }

    public boolean isErrorReportRequired() {
        return this.wrapped.isErrorReportRequired();
    }

    public boolean setErrorReported() {
        return this.wrapped.setErrorReported();
    }

    public void finishResponse() throws IOException {
        this.wrapped.finishResponse();
    }

    public int getContentLength() {
        return this.wrapped.getContentLength();
    }

    public String getContentType() {
        return this.wrapped.getContentType();
    }

    public PrintWriter getReporter() throws IOException {
        return this.wrapped.getReporter();
    }

    public void flushBuffer() throws IOException {
        this.wrapped.flushBuffer();
    }

    public int getBufferSize() {
        return this.wrapped.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.wrapped.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.wrapped.getOutputStream();
    }

    public Locale getLocale() {
        return this.wrapped.getLocale();
    }

    public PrintWriter getWriter() throws IOException {
        return this.wrapped.getWriter();
    }

    public boolean isCommitted() {
        return this.wrapped.isCommitted();
    }

    public void reset() {
        this.wrapped.reset();
    }

    public void resetBuffer() {
        this.wrapped.resetBuffer();
    }

    public void resetBuffer(boolean resetWriterStreamFlags) {
        this.wrapped.resetBuffer(resetWriterStreamFlags);
    }

    public void setBufferSize(int size) {
        this.wrapped.setBufferSize(size);
    }

    public void setContentLength(int length) {
        this.wrapped.setContentLength(length);
    }

    public void setContentLengthLong(long length) {
        this.wrapped.setContentLengthLong(length);
    }

    public void setContentType(String type) {
        this.wrapped.setContentType(type);
    }

    public void setCharacterEncoding(String charset) {
        this.wrapped.setCharacterEncoding(charset);
    }

    public void setLocale(Locale locale) {
        this.wrapped.setLocale(locale);
    }

    public String getHeader(String name) {
        return this.wrapped.getHeader(name);
    }

    public Collection<String> getHeaderNames() {
        return this.wrapped.getHeaderNames();
    }

    public Collection<String> getHeaders(String name) {
        return this.wrapped.getHeaders(name);
    }

    public String getMessage() {
        return this.wrapped.getMessage();
    }

    public int getStatus() {
        return this.wrapped.getStatus();
    }

    public void addCookie(Cookie cookie) {
        if (!this.included && !this.isCommitted()) {
            this.getCookies().add(cookie);
            String header = this.generateCookieString(cookie);
            this.addHeader("Set-Cookie", header, this.getContext().getCookieProcessor().getCharset());
        }
    }

    public void addSessionCookieInternal(Cookie cookie) {
        this.wrapped.addSessionCookieInternal(cookie);
    }

    public void addDateHeader(String name, long value) {
        this.wrapped.addDateHeader(name, value);
    }

    public void addHeader(String name, String value, Charset charset) {
        this.wrapped.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.wrapped.addIntHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this.wrapped.containsHeader(name);
    }

    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.wrapped.setTrailerFields(supplier);
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        return this.wrapped.getTrailerFields();
    }

    public String encodeRedirectURL(String url) {
        return this.wrapped.encodeRedirectURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.wrapped.encodeRedirectUrl(url);
    }

    public String encodeURL(String url) {
        return this.wrapped.encodeURL(url);
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.wrapped.encodeUrl(url);
    }

    public void sendAcknowledgement() throws IOException {
        this.wrapped.sendAcknowledgement();
    }

    public void sendError(int status) throws IOException {
        this.wrapped.sendError(status);
    }

    public void sendError(int status, String message) throws IOException {
        this.wrapped.sendError(status, message);
    }

    public void sendRedirect(String location) throws IOException {
        this.wrapped.sendRedirect(location);
    }

    public void sendRedirect(String location, int status) throws IOException {
        this.wrapped.sendRedirect(location, status);
    }

    public void setDateHeader(String name, long value) {
        this.wrapped.setDateHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.wrapped.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.wrapped.setIntHeader(name, value);
    }

    public void setStatus(int status) {
        this.wrapped.setStatus(status);
    }

    @Deprecated
    public void setStatus(int status, String message) {
        this.wrapped.setStatus(status, message);
    }
}

