/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.valves;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;

public class RequestCorrelationIdValve
extends ValveBase {
    private static final Log correlationLog = LogFactory.getLog((String)"correlation");
    private static final String CORRELATION_ID_MDC = "Correlation-ID";
    private Map<String, String> headerToIdMapping;
    private Map<String, String> queryToIdMapping;
    private static List<String> toRemoveFromThread = new ArrayList<String>();
    private String correlationIdMdc = "Correlation-ID";
    private String headerToCorrelationIdMapping;
    private String queryToCorrelationIdMapping;
    private String configuredCorrelationIdMdc;
    private static final String CORRELATION_LOG_REQUEST_START = "HTTP-In-Request";
    private static final String CORRELATION_LOG_SEPARATOR = "|";
    private static final String CORRELATION_LOG_REQUEST_END = "HTTP-In-Response";
    private static final String CORRELATION_LOG_SYSTEM_PROPERTY = "enableCorrelationLogs";
    private static final String PADDING_CHAR = "=";
    private static final String SPLITTING_CHAR = "&";
    private boolean isEnableCorrelationLogs;

    protected void initInternal() throws LifecycleException {
        super.initInternal();
        Gson gson = new Gson();
        if (StringUtils.isNotEmpty((String)this.headerToCorrelationIdMapping)) {
            this.headerToIdMapping = (Map)gson.fromJson(this.headerToCorrelationIdMapping, Map.class);
            toRemoveFromThread.addAll(this.headerToIdMapping.values());
        }
        if (StringUtils.isNotEmpty((String)this.queryToCorrelationIdMapping)) {
            this.queryToIdMapping = (Map)gson.fromJson(this.queryToCorrelationIdMapping, Map.class);
            toRemoveFromThread.addAll(this.queryToIdMapping.values());
        }
        if (StringUtils.isNotEmpty((String)this.configuredCorrelationIdMdc)) {
            this.correlationIdMdc = this.configuredCorrelationIdMdc;
        }
        this.isEnableCorrelationLogs = Boolean.parseBoolean(System.getProperty(CORRELATION_LOG_SYSTEM_PROPERTY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        long requestStartTime = System.currentTimeMillis();
        try {
            HashMap<String, String> associateToThreadMap = new HashMap<String, String>(this.getHeadersToAssociate((ServletRequest)request));
            if (associateToThreadMap.size() == 0) {
                associateToThreadMap.putAll(this.getQueryParamsToAssociate((ServletRequest)request));
            }
            if (associateToThreadMap.size() == 0) {
                this.associateToThread(UUID.randomUUID().toString());
            } else {
                this.associateToThread(associateToThreadMap);
            }
            if (this.isEnableCorrelationLogs) {
                long currentTime = System.currentTimeMillis();
                long timeTaken = currentTime - requestStartTime;
                this.logRequestDetails(currentTime, timeTaken, CORRELATION_LOG_REQUEST_START, request);
            }
            if (this.getNext() != null) {
                this.getNext().invoke(request, response);
            }
        }
        finally {
            if (this.isEnableCorrelationLogs) {
                long currentTime = System.currentTimeMillis();
                long timeTaken = currentTime - requestStartTime;
                this.logRequestDetails(currentTime, timeTaken, CORRELATION_LOG_REQUEST_END, request);
            }
            this.disAssociateFromThread();
            MDC.remove((String)this.correlationIdMdc);
        }
    }

    private void logRequestDetails(long start, long delta, String callType, Request request) {
        if (correlationLog.isInfoEnabled()) {
            ArrayList<String> logPropertiesList = new ArrayList<String>();
            logPropertiesList.add(Long.toString(delta));
            logPropertiesList.add(callType);
            logPropertiesList.add(Long.toString(start));
            logPropertiesList.add(request.getMethod());
            logPropertiesList.add(request.getQueryString());
            logPropertiesList.add(request.getRequestURI());
            correlationLog.info((Object)this.createFormattedLog(logPropertiesList));
        }
    }

    private String createFormattedLog(List<String> logPropertiesList) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String property : logPropertiesList) {
            sb.append(property);
            if (count < logPropertiesList.size() - 1) {
                sb.append(CORRELATION_LOG_SEPARATOR);
            }
            ++count;
        }
        return sb.toString();
    }

    private void associateToThread(Map<String, String> toAssociate) {
        for (Map.Entry<String, String> entry : toAssociate.entrySet()) {
            MDC.put((String)entry.getKey(), (Object)entry.getValue());
        }
    }

    private void associateToThread(String generatedValue) {
        MDC.put((String)this.correlationIdMdc, (Object)generatedValue);
    }

    private void disAssociateFromThread() {
        if (toRemoveFromThread != null) {
            for (String correlationIdName : toRemoveFromThread) {
                MDC.remove((String)correlationIdName);
            }
        }
    }

    private Map<String, String> getQueryParamsToAssociate(ServletRequest servletRequest) {
        HashMap<String, String> queryToAssociate = new HashMap<String, String>();
        if (this.queryToIdMapping == null || !(servletRequest instanceof HttpServletRequest)) {
            return queryToAssociate;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if (StringUtils.isBlank((String)httpServletRequest.getQueryString())) {
            return queryToAssociate;
        }
        for (Map.Entry<String, String> entry : this.queryToIdMapping.entrySet()) {
            String queryConfigured = entry.getKey();
            String correlationIdName = entry.getValue();
            if (StringUtils.isEmpty((String)queryConfigured) && StringUtils.isEmpty((String)correlationIdName)) continue;
            Map<String, String[]> parameters = this.getQueryParameters(URLDecoder.decode(httpServletRequest.getQueryString()));
            for (Map.Entry<String, String[]> pair : parameters.entrySet()) {
                queryToAssociate.putAll(this.getQueryCorrelationIdValue(pair.getKey(), queryConfigured, String.join((CharSequence)",", pair.getValue()), correlationIdName));
            }
        }
        return queryToAssociate;
    }

    private Map<String, String> getHeadersToAssociate(ServletRequest servletRequest) {
        HashMap<String, String> headersToAssociate = new HashMap<String, String>();
        if (this.headerToIdMapping == null || !(servletRequest instanceof HttpServletRequest)) {
            return headersToAssociate;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        for (Map.Entry<String, String> entry : this.headerToIdMapping.entrySet()) {
            String headerConfigured = entry.getKey();
            String correlationIdName = entry.getValue();
            if (StringUtils.isEmpty((String)headerConfigured) && StringUtils.isEmpty((String)correlationIdName)) continue;
            Enumeration headerNames = httpServletRequest.getHeaderNames();
            if (headerNames == null) {
                return headersToAssociate;
            }
            while (headerNames.hasMoreElements()) {
                String headerReceived = (String)headerNames.nextElement();
                headersToAssociate.putAll(this.getHeaderCorrelationIdValue(headerReceived, headerConfigured, httpServletRequest, correlationIdName));
            }
        }
        return headersToAssociate;
    }

    private Map<String, String> getHeaderCorrelationIdValue(String headerReceived, String headerConfigured, HttpServletRequest httpServletRequest, String correlationIdName) {
        HashMap<String, String> headersToAssociate = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)headerReceived) || !StringUtils.equalsIgnoreCase((String)headerReceived, (String)headerConfigured)) {
            return headersToAssociate;
        }
        String headerValue = httpServletRequest.getHeader(headerReceived);
        if (StringUtils.isNotEmpty((String)headerValue)) {
            headersToAssociate.put(correlationIdName, headerValue);
        }
        return headersToAssociate;
    }

    private Map<String, String> getQueryCorrelationIdValue(String queryReceived, String queryConfigured, String queryValue, String correlationIdName) {
        HashMap<String, String> queryToAssociate = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)queryReceived) || !StringUtils.equalsIgnoreCase((String)queryReceived, (String)queryConfigured)) {
            return queryToAssociate;
        }
        if (StringUtils.isNotEmpty((String)queryValue)) {
            queryToAssociate.put(correlationIdName, queryValue);
        }
        return queryToAssociate;
    }

    private Map<String, String[]> getQueryParameters(String queryString) {
        String[] parameters;
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        if (StringUtils.isEmpty((String)queryString)) {
            return queryParameters;
        }
        for (String parameter : parameters = queryString.split(SPLITTING_CHAR)) {
            String[] keyValuePair = parameter.split(PADDING_CHAR);
            Object[] values = (String[])queryParameters.get(keyValuePair[0]);
            values = (String[])ArrayUtils.add((Object[])values, (Object)(keyValuePair.length == 1 ? "" : keyValuePair[1]));
            queryParameters.put(keyValuePair[0], (String[])values);
        }
        return queryParameters;
    }

    public void setHeaderToCorrelationIdMapping(String headerToCorrelationIdMapping) {
        this.headerToCorrelationIdMapping = headerToCorrelationIdMapping;
    }

    public void setQueryToCorrelationIdMapping(String queryToCorrelationIdMapping) {
        this.queryToCorrelationIdMapping = queryToCorrelationIdMapping;
    }

    public void setConfiguredCorrelationIdMdc(String configuredCorrelationIdMdc) {
        this.configuredCorrelationIdMdc = configuredCorrelationIdMdc;
    }
}

