/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.valves;

import java.io.CharArrayWriter;
import java.util.Map;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.AbstractAccessLogValve;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.log4j.MDC;

public class ConfigurableLoggerAccessLogValve
extends AbstractAccessLogValve {
    private static final Log log = LogFactory.getLog(AccessLogValve.class);
    private static final org.apache.commons.logging.Log ACCESS_LOG = org.apache.commons.logging.LogFactory.getLog((String)"HTTP_ACCESS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Request request, Response response, long time) {
        Map toAssociateMdc = (Map)request.getAttribute("org.wso2.request.correlation.MDC");
        this.copyMdcFromRequest(toAssociateMdc);
        try {
            super.log(request, response, time);
        }
        finally {
            this.removeMdcCopiedFromRequest(toAssociateMdc);
        }
    }

    public void log(CharArrayWriter message) {
        if (ACCESS_LOG.isInfoEnabled()) {
            ACCESS_LOG.info((Object)message.toString());
        }
    }

    private void removeMdcCopiedFromRequest(Map<String, String> toAssociateMdc) {
        if (toAssociateMdc != null) {
            for (Map.Entry<String, String> entry : toAssociateMdc.entrySet()) {
                MDC.remove((String)entry.getKey());
            }
        }
    }

    private void copyMdcFromRequest(Map<String, String> toAssociateMdc) {
        if (toAssociateMdc != null) {
            for (Map.Entry<String, String> entry : toAssociateMdc.entrySet()) {
                MDC.put((String)entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

