/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestEncodingValve
extends ValveBase {
    private static Log log = LogFactory.getLog(RequestEncodingValve.class);
    private String encoding = "UTF-8";

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (null == request.getCharacterEncoding()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The request has no character encoding. Hence, setting the encoding to " + this.encoding));
            }
            request.setCharacterEncoding(this.encoding);
        }
        if (this.getNext() != null) {
            this.getNext().invoke(request, response);
        }
    }

    public void setEncoding(String encoding) {
        if (encoding != null) {
            this.encoding = encoding;
        } else if (System.getProperty("file.encoding") != null) {
            this.encoding = System.getProperty("file.encoding");
        }
    }

    public String getEncoding() {
        return this.encoding;
    }
}

