/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.valves;

import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.wso2.carbon.tomcat.ext.valves.CarbonTomcatValve;
import org.wso2.carbon.tomcat.ext.valves.CompositeValve;

public class TomcatValveContainer {
    private static List<CarbonTomcatValve> valves = new ArrayList<CarbonTomcatValve>();

    public static void invokeValves(Request request, Response response, CompositeValve compositeValve) {
        if (valves.size() > 0) {
            valves.get(0).invoke(request, response, compositeValve);
        } else {
            compositeValve.continueInvocation(request, response);
        }
    }

    public static synchronized void addValves(List<CarbonTomcatValve> valves) {
        for (CarbonTomcatValve valve : valves) {
            TomcatValveContainer.addValve(valve);
        }
    }

    private static void addValve(CarbonTomcatValve valve) {
        if (valves.size() > 0) {
            valves.get(valves.size() - 1).setNext(valve);
        }
        valves.add(valve);
    }

    public static synchronized void addValves(int index, List<CarbonTomcatValve> valves) {
        CarbonTomcatValve lastValveOfNewValvesList;
        CarbonTomcatValve previousValve;
        if (valves == null || valves.isEmpty()) {
            return;
        }
        if (index < 0 || index > TomcatValveContainer.valves.size()) {
            throw new IllegalArgumentException("Invalid value specified for index: " + index);
        }
        if (index > 0 && (previousValve = TomcatValveContainer.valves.get(index - 1)) != null) {
            previousValve.setNext(valves.get(0));
        }
        if (index < TomcatValveContainer.valves.size() && (lastValveOfNewValvesList = valves.get(valves.size() - 1)) != null) {
            lastValveOfNewValvesList.setNext(TomcatValveContainer.valves.get(index));
        }
        for (int i = 0; i < valves.size() - 1; ++i) {
            valves.get(i).setNext(valves.get(i + 1));
        }
        TomcatValveContainer.valves.addAll(index, valves);
    }

    public static boolean isValveExists(CarbonTomcatValve carbonTomcatValve) {
        return valves.contains(carbonTomcatValve);
    }
}

