/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.digester.Digester;
import org.wso2.carbon.tomcat.CarbonTomcatException;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.tomcat.internal.SCIRegistrarContextConfig;
import org.xml.sax.SAXException;

public class CarbonTomcat
extends Tomcat
implements CarbonTomcatService {
    private static Log log = LogFactory.getLog(CarbonTomcat.class);
    private ExtendedCatalina catalina = new ExtendedCatalina();
    private String globalWebXml;
    private String globalContextXml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(String baseDir, InputStream inputStream) {
        this.setBaseDir(baseDir);
        String configPath = System.getProperty("carbon.config.dir.path");
        if (configPath == null) {
            this.globalWebXml = Paths.get(System.getProperty("carbon.home"), "repository", "conf", "tomcat", "web.xml").toString();
            this.globalContextXml = Paths.get(System.getProperty("carbon.home"), "repository", "conf", "tomcat", "context.xml").toString();
        } else {
            this.globalWebXml = Paths.get(configPath, "tomcat", "web.xml").toString();
            this.globalContextXml = Paths.get(configPath, "tomcat", "context.xml").toString();
        }
        Digester digester = this.catalina.createStartDigester();
        digester.push((Object)this);
        try {
            digester.parse(inputStream);
        }
        catch (IOException e) {
            log.error((Object)"error while reading xml stream", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"error while parsing xml stream", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"error while closing the inputStream", (Throwable)e);
            }
        }
    }

    public void start() throws LifecycleException {
        this.getServer();
        this.server.start();
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Service getService() {
        Server server = this.getServer();
        Service[] findServices = server.findServices();
        if (findServices != null && findServices.length > 0) {
            return findServices[0];
        }
        throw new IllegalStateException("Unable to locate Service.");
    }

    public Host getHost() {
        return this.findHost();
    }

    public Engine getEngine() {
        return this.findEngine();
    }

    private Engine findEngine() {
        Service[] findServices;
        Server server = this.getServer();
        for (Service service : findServices = server.findServices()) {
            Container container = service.getContainer();
            if (!(container instanceof Engine)) continue;
            return (Engine)container;
        }
        throw new IllegalStateException("Unable to locate Engine.");
    }

    private Host findHost() {
        if (this.host == null) {
            Engine engine = this.findEngine();
            String defaultHost = engine.getDefaultHost();
            Container child = engine.findChild(defaultHost);
            return (Host)child;
        }
        return this.host;
    }

    public void init() throws LifecycleException {
        this.getServer();
        this.server.init();
    }

    @Override
    public Context addWebApp(String contextPath, String webappFilePath) throws CarbonTomcatException {
        Host defaultHost = (Host)this.getEngine().findChild(this.getEngine().getDefaultHost());
        return this.addWebApp(defaultHost, contextPath, webappFilePath, null);
    }

    @Override
    public Context addWebApp(Host host, String contextPath, String webappFilePath) throws CarbonTomcatException {
        return this.addWebApp(host, contextPath, webappFilePath, null);
    }

    @Override
    public Context addWebApp(String contextPath, String webappFilePath, LifecycleListener lifecycleListener) throws CarbonTomcatException {
        Host defaultHost = (Host)this.getEngine().findChild(this.getEngine().getDefaultHost());
        return this.addWebApp(defaultHost, contextPath, webappFilePath, lifecycleListener);
    }

    @Override
    public Context addWebApp(Host host, String contextPath, String webappFilePath, LifecycleListener lifecycleListener) throws CarbonTomcatException {
        ZipFile webappJarFile = null;
        StandardContext ctx = null;
        boolean removeContext = false;
        try {
            File f;
            Container child = host.findChild(contextPath);
            if (child != null && ctx != null && host != null) {
                ctx.setRealm(null);
                try {
                    ctx.stop();
                }
                catch (LifecycleException x) {
                    log.error((Object)"Cannot stop context ", (Throwable)x);
                }
                host.removeChild((Container)ctx);
            }
            ctx = new StandardContext();
            ctx.setName(contextPath);
            ctx.setPath(contextPath);
            ctx.setDocBase(webappFilePath);
            ctx.setRealm(host.getRealm());
            if (lifecycleListener != null) {
                ctx.addLifecycleListener(lifecycleListener);
            }
            SCIRegistrarContextConfig sciRegistrarContextConfig = new SCIRegistrarContextConfig();
            ctx.addLifecycleListener((LifecycleListener)sciRegistrarContextConfig);
            if (new File(this.globalWebXml).exists()) {
                sciRegistrarContextConfig.setDefaultWebXml(this.globalWebXml);
            } else {
                sciRegistrarContextConfig.setDefaultWebXml("org/apache/catalin/startup/NO_DEFAULT_XML");
            }
            if (new File(this.globalContextXml).exists()) {
                sciRegistrarContextConfig.setDefaultContextXml(this.globalContextXml);
            }
            if ((f = new File(webappFilePath)).isDirectory()) {
                File cf = new File(webappFilePath + File.separator + "META-INF/context.xml");
                if (cf.exists()) {
                    ctx.setConfigFile(cf.toURI().toURL());
                }
            } else {
                webappJarFile = new JarFile(webappFilePath);
                JarEntry contextXmlFileEntry = ((JarFile)webappJarFile).getJarEntry("META-INF/context.xml");
                if (contextXmlFileEntry != null) {
                    ctx.setConfigFile(new URL("jar:file:" + URLEncoder.encode(webappFilePath, "UTF-8") + "!/" + "META-INF/context.xml"));
                }
            }
            if (ctx instanceof StandardContext) {
                ctx.setClearReferencesStopTimerThreads(true);
            }
            if (host == null) {
                host = this.getHost();
            }
            host.addChild((Container)ctx);
            if (ctx.getState().equals((Object)LifecycleState.STOPPED)) {
                ctx.setRealm(null);
                ctx.destroy();
                throw new Exception("Webapp failed to deploy, Lifecycle state is STOPPED");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Webapp context: " + ctx));
            }
        }
        catch (Exception e) {
            removeContext = true;
            throw new CarbonTomcatException("Webapp failed to deploy", e);
        }
        finally {
            if (removeContext && ctx != null && host != null) {
                ctx.setRealm(null);
                try {
                    if (!ctx.getState().equals((Object)LifecycleState.STOPPED)) {
                        ctx.stop();
                    }
                }
                catch (LifecycleException e) {
                    log.error((Object)"Cannot stop context ", (Throwable)e);
                }
                host.removeChild((Container)ctx);
                log.error((Object)("Webapp " + ctx + " failed to deploy"));
            }
            if (webappJarFile != null) {
                try {
                    webappJarFile.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                }
            }
        }
        return ctx;
    }

    @Override
    public Tomcat getTomcat() {
        return this;
    }

    @Override
    public int getPort(String scheme) {
        for (Connector connector : this.getService().findConnectors()) {
            if (!connector.getScheme().equals(scheme)) continue;
            return connector.getPort();
        }
        return -1;
    }

    @Override
    public int getProxyPort(String scheme) {
        for (Connector connector : this.getService().findConnectors()) {
            if (!connector.getScheme().equals(scheme)) continue;
            return connector.getProxyPort();
        }
        return -1;
    }

    @Override
    @Deprecated
    public void startConnectors(int portOffset, String keyPass, String keyStorePass, String keyStoreFile) {
        Connector[] connectors;
        for (Connector connector : connectors = this.getService().findConnectors()) {
            try {
                int currentPort = connector.getPort();
                connector.setPort(currentPort + portOffset);
                if (connector.getProtocolHandler() instanceof Http11NioProtocol) {
                    ((Http11NioProtocol)connector.getProtocolHandler()).setKeyPass(keyPass);
                    ((Http11NioProtocol)connector.getProtocolHandler()).setKeystorePass(keyStorePass);
                    ((Http11NioProtocol)connector.getProtocolHandler()).setKeystoreFile(keyStoreFile);
                }
                connector.start();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("staring the tomcat connector : " + connector.getProtocol()));
            }
            catch (LifecycleException e) {
                log.error((Object)"LifeCycleException while starting tomcat connector", (Throwable)e);
            }
        }
    }

    @Override
    public void startConnectors(int portOffset) {
        Connector[] connectors;
        for (Connector connector : connectors = this.getService().findConnectors()) {
            try {
                String isRandomPort = System.getProperty("tomcat.random.port.enable");
                if (isRandomPort != null && isRandomPort.equals("true")) {
                    connector.setPort(CarbonTomcat.findFreePort());
                    connector.setProxyPort(connector.getProxyPort() + portOffset);
                } else {
                    String portNumber = System.getProperty("tomcat." + connector.getScheme() + ".port");
                    if (portNumber != null) {
                        connector.setPort(Integer.parseInt(portNumber));
                        connector.setProxyPort(connector.getProxyPort() + portOffset);
                    } else {
                        int currentPort = connector.getPort();
                        connector.setPort(currentPort + portOffset);
                    }
                }
                connector.start();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("staring the tomcat connector : " + connector.getProtocol()));
            }
            catch (LifecycleException e) {
                log.error((Object)"LifeCycleException while starting tomcat connector", (Throwable)e);
            }
        }
    }

    @Override
    public void startConnector(String scheme, int portOffset) {
        Connector[] connectors;
        for (Connector connector : connectors = this.getService().findConnectors()) {
            if (!connector.getScheme().equals(scheme)) continue;
            try {
                String isRandomPort = System.getProperty("tomcat.random.port.enable");
                if (isRandomPort != null && isRandomPort.equals("true")) {
                    connector.setPort(CarbonTomcat.findFreePort());
                    connector.setProxyPort(connector.getProxyPort() + portOffset);
                } else {
                    String portNumber = System.getProperty("tomcat." + connector.getScheme() + ".port");
                    if (portNumber != null) {
                        connector.setPort(Integer.parseInt(portNumber));
                        connector.setProxyPort(connector.getProxyPort() + portOffset);
                    } else {
                        int currentPort = connector.getPort();
                        connector.setPort(currentPort + portOffset);
                    }
                }
                connector.start();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("staring the tomcat connector : " + connector.getProtocol()));
            }
            catch (LifecycleException e) {
                log.error((Object)"LifeCycleException while starting tomcat connector", (Throwable)e);
            }
        }
    }

    @Override
    public void stopConnectors() {
        Connector[] connectors;
        for (Connector connector : connectors = this.getService().findConnectors()) {
            try {
                connector.stop();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("stopping the tomcat connector : " + connector.getProtocol()));
            }
            catch (LifecycleException e) {
                log.error((Object)"LifeCycleException while starting tomcat connector", (Throwable)e);
            }
        }
    }

    @Override
    public void stopConnector(String scheme) {
        Connector[] connectors;
        for (Connector connector : connectors = this.getService().findConnectors()) {
            if (!connector.getScheme().equals(scheme)) continue;
            try {
                connector.stop();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("stopping the tomcat connector : " + connector.getProtocol()));
            }
            catch (LifecycleException e) {
                log.error((Object)"LifeCycleException while stopping tomcat connector", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isUnpackWARs() {
        StandardHost standardHost = (StandardHost)this.getHost();
        return standardHost.isUnpackWARs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean available(int port) {
        ServerSocket serverSocket = null;
        DatagramSocket dataSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            serverSocket.setReuseAddress(true);
            dataSocket = new DatagramSocket(port);
            dataSocket.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (dataSocket != null) {
                dataSocket.close();
            }
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error occurred while closing the " + port + " port."));
                }
            }
        }
    }

    private static int findFreePort() {
        int i = 30000 + (int)(Math.random() * 10001.0);
        if (CarbonTomcat.available(i)) {
            return i;
        }
        return CarbonTomcat.findFreePort();
    }

    private static class ExtendedCatalina
    extends Catalina {
        private ExtendedCatalina() {
        }

        public Digester createStartDigester() {
            return super.createStartDigester();
        }
    }
}

