/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.internal;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.tomcat.internal.ServerManager;
import org.wso2.carbon.tomcat.jndi.JNDIURLStreamHandlerService;

public class TomcatBundleActivator
implements BundleActivator {
    private static Log log = LogFactory.getLog(TomcatBundleActivator.class);
    private ServerManager serverManager;
    private ServiceRegistration serviceRegistration;

    public void start(BundleContext bundleContext) throws Exception {
        try {
            this.serverManager = new ServerManager();
            this.serverManager.init();
            this.serverManager.start();
            this.serviceRegistration = bundleContext.registerService(CarbonTomcatService.class.getName(), (Object)this.serverManager.getTomcatInstance(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Registering the JNDI stream handler...");
            }
            Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
            properties.put("url.handler.protocol", new String[]{"jndi"});
            bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new JNDIURLStreamHandlerService(), properties);
        }
        catch (Throwable t) {
            log.fatal((Object)("Error while starting server " + t.getMessage()), t);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.serverManager.stop();
        this.serviceRegistration.unregister();
        this.serverManager = null;
    }
}

