/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.tomcat.internal.ServerManager;

public class TomcatBundleActivator
implements BundleActivator {
    private static Log log = LogFactory.getLog(TomcatBundleActivator.class);
    private ServerManager serverManager;
    private ServiceRegistration serviceRegistration;

    public void start(BundleContext bundleContext) throws Exception {
        try {
            this.serverManager = new ServerManager();
            this.serverManager.init();
            this.serverManager.start();
            this.serviceRegistration = bundleContext.registerService(CarbonTomcatService.class.getName(), (Object)this.serverManager.getTomcatInstance(), null);
        }
        catch (Throwable t) {
            log.fatal((Object)("Error while starting server " + t.getMessage()), t);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.serverManager.stop();
        this.serviceRegistration.unregister();
        this.serverManager = null;
    }
}

