/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.tomcat.internal.CarbonTomcat;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.wso2.securevault.secret.SecretManager;
import org.xml.sax.SAXException;

public class ServerManager {
    private static Log log = LogFactory.getLog(ServerManager.class);
    private static CarbonTomcat tomcat;
    private InputStream inputStream;
    private SecretResolver resolver;
    static ClassLoader bundleCtxtClassLoader;
    private static final String SVNS = "svns";
    private static final String CARBON_URL_CONTEXT_FACTORY_PKG_PREFIX = "org.wso2.carbon.tomcat.jndi";
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    public void init() {
        String catalinaHome;
        String catalinaPropertiesXml;
        String catalinaXML;
        bundleCtxtClassLoader = Thread.currentThread().getContextClassLoader();
        String carbonHome = System.getProperty("carbon.home");
        String configPath = System.getProperty("carbon.config.dir.path");
        if (configPath == null) {
            catalinaXML = Paths.get(carbonHome, "repository", "conf", "tomcat", "catalina-server.xml").toString();
            catalinaPropertiesXml = Paths.get(carbonHome, "repository", "conf", "tomcat", "catalina.properties").toString();
        } else {
            catalinaXML = Paths.get(configPath, "tomcat", "catalina-server.xml").toString();
            catalinaPropertiesXml = Paths.get(configPath, "tomcat", "catalina.properties").toString();
        }
        try {
            System.setProperty("catalina.config", new File(catalinaPropertiesXml).toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            log.error((Object)"could not locate the file catalina.properties", (Throwable)e);
        }
        try {
            this.inputStream = new FileInputStream(new File(catalinaXML));
        }
        catch (FileNotFoundException e) {
            log.error((Object)"could not locate the file catalina-server.xml", (Throwable)e);
        }
        String internalLibPath = System.getProperty("carbon.internal.lib.dir.path");
        if (internalLibPath == null) {
            if (System.getProperty("catalina.base") == null) {
                System.setProperty("catalina.base", Paths.get(carbonHome, "lib", "tomcat").toString());
            }
            catalinaHome = Paths.get(carbonHome, "lib", "tomcat").toString();
        } else {
            System.setProperty("catalina.base", Paths.get(internalLibPath, "tomcat").toString());
            catalinaHome = Paths.get(internalLibPath, "tomcat").toString();
        }
        String value = CARBON_URL_CONTEXT_FACTORY_PKG_PREFIX;
        String oldValue = System.getProperty("java.naming.factory.url.pkgs");
        if (oldValue != null) {
            value = oldValue.contains(CARBON_URL_CONTEXT_FACTORY_PKG_PREFIX) ? oldValue : "org.wso2.carbon.tomcat.jndi:" + oldValue;
        }
        System.setProperty("java.naming.factory.url.pkgs", value);
        TomcatURLStreamHandlerFactory.disable();
        tomcat = new CarbonTomcat();
        Element config = ServerManager.inputStreamToDOM(this.inputStream);
        if (SecretManager.getInstance().isInitialized()) {
            this.resolver = SecretResolverFactory.create((Element)config, (boolean)true);
            this.resolveSecuredConfig(config, null);
        }
        if (config.getAttributes().getNamedItem("xmlns:svns") != null) {
            config.getAttributes().removeNamedItem("xmlns:svns");
        }
        InputStream newStream = this.domToInputStream(config);
        tomcat.configure(catalinaHome, newStream);
    }

    public synchronized void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(bundleCtxtClassLoader);
                try {
                    tomcat.start();
                }
                catch (LifecycleException e) {
                    log.error((Object)"tomcat life-cycle exception", (Throwable)e);
                }
            }
        }).start();
    }

    public void stop() {
        try {
            tomcat.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)"Error while stopping tomcat", (Throwable)e);
        }
    }

    CarbonTomcat getTomcatInstance() {
        return tomcat;
    }

    private void resolveSecuredConfig(Node root, String tempToken) {
        String token = null;
        NamedNodeMap nodeMap = root.getAttributes();
        tempToken = tempToken == null ? root.getNodeName() : tempToken + "." + root.getNodeName();
        if (nodeMap != null) {
            for (int j = 0; j < nodeMap.getLength(); ++j) {
                Node node = nodeMap.item(j);
                if (node == null) continue;
                String alias = MiscellaneousUtil.getProtectedToken((String)node.getNodeValue());
                if (alias != null && alias.length() > 0) {
                    node.setNodeValue(MiscellaneousUtil.resolve((String)alias, (SecretResolver)this.resolver));
                    continue;
                }
                String attributeName = node.getNodeName();
                token = tempToken + "." + attributeName;
                if (!this.resolver.isTokenProtected(token)) continue;
                node.setNodeValue(this.resolver.resolve(token));
                try {
                    nodeMap.removeNamedItem("svns:secretAlias");
                    continue;
                }
                catch (DOMException e) {
                    String msg = "Error while removing svns:secretAlias";
                    log.debug((Object)msg, (Throwable)e);
                }
            }
        }
        NodeList nodeList = root.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.resolveSecuredConfig(nodeList.item(i), tempToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element inputStreamToDOM(InputStream inputStream) {
        DocumentBuilderFactory factory = ServerManager.getSecuredDocumentBuilder();
        Element element = null;
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(inputStream);
            element = doc.getDocumentElement();
        }
        catch (SAXException e) {
            log.error((Object)"Error while creating DOM element : ", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error while creating DOM element : ", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Error while creating DOM element : ", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing input stream : ", (Throwable)e);
            }
        }
        return element;
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    private InputStream domToInputStream(Element root) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            Transformer t = CarbonUtils.getSecureTransformerFactory().newTransformer();
            t.transform(new DOMSource(root), outputTarget);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"Error while creating input stream : ", (Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)"Error while creating input stream : ", (Throwable)e);
        }
        return null;
    }
}

