/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ui.Utils;
import org.wso2.carbon.ui.deployment.beans.Component;
import org.wso2.carbon.ui.deployment.beans.Menu;

public class ComponentDeployer {
    private final String[] mainTemplateSuffixes = new String[]{"script_header", "menu", "main_layout"};
    private static Log log = LogFactory.getLog(ComponentDeployer.class);
    private Bundle componentBundle;
    private static final Map<String, String> processedFileMap = new HashMap<String, String>();

    public ComponentDeployer(Bundle componentBundle) {
        this.componentBundle = componentBundle;
    }

    public void layout(Map<Long, Component> componentMap) throws CarbonException {
        Collection<Component> componentCollection = componentMap.values();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement componentEle = fac.createOMElement(new QName("component"));
        OMElement tagLibsEle = fac.createOMElement(new QName("taglibs"));
        componentEle.addChild((OMNode)tagLibsEle);
        OMElement jsFilesEle = fac.createOMElement(new QName("js-files"));
        OMElement generalEle = fac.createOMElement(new QName("general"));
        componentEle.addChild((OMNode)jsFilesEle);
        componentEle.addChild((OMNode)generalEle);
        ArrayList<Menu> menuList = new ArrayList<Menu>();
        for (Component component : componentCollection) {
            menuList.addAll(component.getMenusList());
        }
        Collections.sort(menuList, new Comparator<Menu>(){

            @Override
            public int compare(Menu m1, Menu m2) {
                return m1.compareTo(m2);
            }
        });
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (log.isDebugEnabled()) {
            log.debug((Object)("intermediate : " + componentEle));
        }
        try {
            componentEle.serializeAndConsume((OutputStream)bos);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new CarbonException((Throwable)e);
        }
        byte[] bytes = bos.toByteArray();
        try {
            for (String templatSuffix : this.mainTemplateSuffixes) {
                String xslResourceName = "ui/" + templatSuffix + ".xsl";
                URL xslResource = this.componentBundle.getResource(xslResourceName);
                if (xslResource == null) {
                    throw new CarbonException(xslResourceName + " is not avaiable in component bundle");
                }
                ByteArrayOutputStream jspBos = new ByteArrayOutputStream();
                Utils.transform(new ByteArrayInputStream(bytes), xslResource.openStream(), jspBos);
                processedFileMap.put("web/" + templatSuffix + ".jsp", new String(jspBos.toByteArray()));
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new CarbonException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new CarbonException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CarbonException((Throwable)e);
        }
    }

    public static String getFragment(String key) {
        return processedFileMap.get(key);
    }
}

