/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.ExceptionException;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfo;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfoAdminStub;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.UIAuthenticationExtender;
import org.wso2.carbon.ui.internal.CarbonUIServiceComponent;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantConstants;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public abstract class AbstractCarbonUIAuthenticator
implements CarbonUIAuthenticator {
    private static final int DEFAULT_PRIORITY_LEVEL = 5;
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String REMEMBER_ME = "rememberMe";
    protected static final Log log = LogFactory.getLog(AbstractCarbonUIAuthenticator.class);
    private static Log audit = CarbonConstants.AUDIT_LOG;

    @Override
    public boolean isDisabled() {
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = this.getAuthenticatorConfig();
        return authenticatorConfig != null && authenticatorConfig.isDisabled();
    }

    @Override
    public int getPriority() {
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = this.getAuthenticatorConfig();
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return 5;
    }

    @Override
    public List<String> getSessionValidationSkippingUrls() {
        ArrayList<String> skippingUrls = new ArrayList<String>(Arrays.asList("/samlsso", "sso-saml/login.jsp", "stratos-sso/login_ajaxprocessor.jsp", "sso-saml/redirect_ajaxprocessor.jsp", "stratos-sso/redirect_ajaxprocessor.jsp", "sso-acs/redirect_ajaxprocessor.jsp", "stratos-auth/redirect_ajaxprocessor.jsp"));
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = this.getAuthenticatorConfig();
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            skippingUrls.addAll(authenticatorConfig.getSessionValidationSkippingUrls());
        }
        return skippingUrls;
    }

    @Override
    public List<String> getAuthenticationSkippingUrls() {
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = this.getAuthenticatorConfig();
        if (authenticatorConfig != null) {
            return authenticatorConfig.getAuthenticationSkippingUrls();
        }
        return new ArrayList<String>(0);
    }

    public abstract String doAuthentication(Object var1, boolean var2, ServiceClient var3, HttpServletRequest var4) throws AuthenticationException;

    public abstract void handleRememberMe(Map var1, HttpServletRequest var2) throws AuthenticationException;

    protected boolean isAdminCookieSet() {
        return false;
    }

    private void regenrateSession(HttpServletRequest request) {
        HttpSession oldSession = request.getSession();
        Enumeration<Object> attrNames = oldSession.getAttributeNames();
        Properties props = new Properties();
        while (attrNames != null && attrNames.hasMoreElements()) {
            String key = (String)attrNames.nextElement();
            props.put(key, oldSession.getAttribute(key));
        }
        oldSession.invalidate();
        HttpSession newSession = request.getSession(true);
        attrNames = props.keys();
        while (attrNames != null && attrNames.hasMoreElements()) {
            String key = (String)attrNames.nextElement();
            newSession.setAttribute(key, props.get(key));
        }
    }

    public void handleSecurity(Object credentials, boolean rememberMe, HttpServletRequest request) throws AuthenticationException {
        this.regenrateSession(request);
        String backendServerURL = this.getBackendUrl(request);
        HttpSession session = request.getSession();
        String loggedinUser = null;
        if (backendServerURL == null) {
            throw new AuthenticationException("Server not initialized properly.");
        }
        try {
            LoggedUserInfoAdminStub stub = this.getLoggedUserInfoAdminStub(backendServerURL, session);
            ServiceClient client = stub._getServiceClient();
            loggedinUser = this.doAuthentication(credentials, rememberMe, client, request);
            if (this.isAdminCookieSet()) {
                client.getServiceContext().setProperty("Cookie", session.getAttribute("wso2carbon.admin.service.cookie"));
            }
            this.setUserAuthorizationInfo(stub, session);
            if (!this.isAdminCookieSet()) {
                this.setAdminCookie(session, client, null);
            }
            if (rememberMe) {
                OperationContext operationContext = client.getLastOperationContext();
                MessageContext inMessageContext = operationContext.getMessageContext("In");
                Map transportHeaders = (Map)inMessageContext.getProperty("TRANSPORT_HEADERS");
                this.handleRememberMe(transportHeaders, request);
            }
            this.onSuccessAdminLogin(request, loggedinUser);
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new AuthenticationException("Exception occurred while accessing user authorization info", (Throwable)e);
        }
    }

    @Override
    public boolean skipLoginPage() {
        return false;
    }

    public void onSuccessAdminLogin(HttpServletRequest request, String userName) throws Exception {
        UIAuthenticationExtender[] uiAuthenticationExtenders;
        HttpSession session = request.getSession();
        String tenantDomain = session.getAttribute("tenantDomain") != null ? session.getAttribute("tenantDomain").toString() : MultitenantUtils.getTenantDomain((String)userName);
        if (tenantDomain != null && tenantDomain.trim().length() > 0) {
            session.setAttribute("tenantDomain", (Object)tenantDomain);
            if (request.getAttribute("tenantDomain") == null) {
                request.setAttribute("tenantDomain", (Object)tenantDomain);
            }
        } else {
            audit.info((Object)"User with null domain tried to login.");
            return;
        }
        String tenantAwareUserName = session.getAttribute("logged-user") != null ? (String)session.getAttribute("logged-user") : MultitenantUtils.getTenantAwareUsername((String)userName);
        request.setAttribute(USERNAME, (Object)tenantAwareUserName);
        String serverURL = this.getBackendUrl(request);
        if (serverURL == null) {
            throw new AuthenticationException("Server not initialized properly.");
        }
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        if (!(serverURL != null && cookie != null || CarbonUtils.isRunningOnLocalTransportMode())) {
            throw new Exception("Cannot proceed logging in. The server URL and/or Cookie is null");
        }
        if (tenantDomain != null && "carbon.super".equals(tenantDomain.trim())) {
            request.getSession().setAttribute(MultitenantConstants.IS_SUPER_TENANT, (Object)"true");
        } else if (tenantDomain != null && tenantDomain.trim().length() > 0) {
            session.setAttribute("tenantDomain", (Object)tenantDomain);
            if (request.getAttribute("tenantDomain") == null) {
                request.setAttribute("tenantDomain", (Object)tenantDomain);
            }
        } else {
            audit.info((Object)"User with null domain tried to login.");
            return;
        }
        this.setUserInformation(cookie, serverURL, session);
        session.setAttribute("logged-user", (Object)tenantAwareUserName);
        session.getServletContext().setAttribute("logged-user", (Object)tenantAwareUserName);
        session.setAttribute("authenticated", (Object)Boolean.parseBoolean("true"));
        for (UIAuthenticationExtender uiAuthenticationExtender : uiAuthenticationExtenders = CarbonUIServiceComponent.getUIAuthenticationExtenders()) {
            uiAuthenticationExtender.onSuccessAdminLogin(request, tenantAwareUserName, tenantDomain, serverURL);
        }
    }

    protected void setUserInformation(String cookie, String backendServerURL, HttpSession session) throws RemoteException {
        try {
            if (session.getAttribute("user-permissions") != null) {
                return;
            }
            ServletContext servletContext = session.getServletContext();
            ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
            LoggedUserInfoAdminStub stub = new LoggedUserInfoAdminStub(configContext, backendServerURL + "LoggedUserInfoAdmin");
            ServiceClient client = stub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)cookie);
            LoggedUserInfo userInfo = stub.getUserInfo();
            String[] permissionArray = userInfo.getUIPermissionOfUser();
            ArrayList<String> list = new ArrayList<String>();
            for (String permission : permissionArray) {
                list.add(permission);
            }
            session.setAttribute("user-permissions", list);
            if (userInfo.getPasswordExpiration() != null) {
                session.setAttribute("passwordExpires", (Object)userInfo.getPasswordExpiration());
            }
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AxisFault("Exception occured", (Throwable)e);
        }
    }

    protected static String getUserNameFromCookie(String cookieValue) {
        int index = cookieValue.indexOf(45);
        return cookieValue.substring(0, index);
    }

    protected void setAdminCookie(HttpSession session, ServiceClient serviceClient, String rememberMeCookie) throws AxisFault {
        String cookie = (String)serviceClient.getServiceContext().getProperty("Cookie");
        if (cookie == null) {
            cookie = UUIDGenerator.generateUUID();
        }
        if (rememberMeCookie != null) {
            cookie = cookie + "; " + rememberMeCookie;
        }
        if (session != null) {
            session.setAttribute("wso2carbon.admin.service.cookie", (Object)cookie);
        }
    }

    private LoggedUserInfoAdminStub getLoggedUserInfoAdminStub(String backendServerURL, HttpSession session) throws AxisFault {
        ServletContext servletContext = session.getServletContext();
        ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        if (configContext == null) {
            String msg = "Configuration context is null.";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        return new LoggedUserInfoAdminStub(configContext, backendServerURL + "LoggedUserInfoAdmin");
    }

    private void setUserAuthorizationInfo(LoggedUserInfoAdminStub loggedUserInfoAdminStub, HttpSession session) throws ExceptionException, RemoteException {
        ServiceClient client = loggedUserInfoAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        LoggedUserInfo userInfo = loggedUserInfoAdminStub.getUserInfo();
        String[] permissionArray = userInfo.getUIPermissionOfUser();
        ArrayList list = new ArrayList();
        Collections.addAll(list, permissionArray);
        session.setAttribute("user-permissions", list);
        if (userInfo.getPasswordExpiration() != null) {
            session.setAttribute("passwordExpires", (Object)userInfo.getPasswordExpiration());
        }
        if (session.getAttribute("logged-user") == null) {
            session.setAttribute("logged-user", (Object)userInfo.getUserName());
        }
    }

    private String getBackendUrl(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        String backendServerURL = CarbonUIUtil.getServerURL(servletContext, request.getSession());
        if (backendServerURL != null) {
            session.setAttribute("ServerURL", (Object)backendServerURL);
        }
        return backendServerURL;
    }

    private AuthenticatorsConfiguration.AuthenticatorConfig getAuthenticatorConfig() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(this.getAuthenticatorName());
        return authenticatorConfig;
    }
}

