/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.ui.internal.CarbonUIServiceComponent;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class CarbonConnection
extends URLConnection {
    private static final Log log = LogFactory.getLog(CarbonConnection.class);
    private byte[] buf = null;

    protected CarbonConnection(URL url, BundleContext context) throws Exception {
        super(url);
        TransportInDescription httpInDescription;
        ConfigurationContext configContext = CarbonUIServiceComponent.getConfigurationContextService().getServerConfigContext();
        TransportInDescription httpsInDescription = configContext.getAxisConfiguration().getTransportIn("https");
        Parameter proxyParameter = httpsInDescription.getParameter("proxyPort");
        String httpsProxyPort = null;
        if (proxyParameter != null && !"-1".equals(proxyParameter.getValue())) {
            httpsProxyPort = (String)proxyParameter.getValue();
        }
        if ((httpInDescription = configContext.getAxisConfiguration().getTransportIn("http")) != null) {
            proxyParameter = httpInDescription.getParameter("proxyPort");
        }
        String httpProxyPort = null;
        if (proxyParameter != null && !"-1".equals(proxyParameter.getValue())) {
            httpProxyPort = (String)proxyParameter.getValue();
        }
        try {
            String servicePath = configContext.getServicePath();
            String contextRoot = configContext.getContextRoot();
            contextRoot = contextRoot.equals("/") ? "" : contextRoot;
            String httpsPort = httpsProxyPort != null ? httpsProxyPort : CarbonUtils.getTransportPort((ConfigurationContextService)CarbonUIServiceComponent.getConfigurationContextService(), (String)"https") + "";
            String httpPort = httpProxyPort != null ? httpProxyPort : (httpInDescription != null ? CarbonUtils.getTransportPort((ConfigurationContextService)CarbonUIServiceComponent.getConfigurationContextService(), (String)"http") + "" : "-1");
            this.buf = ("var SERVICE_PATH=\"" + servicePath + "\";\nvar ROOT_CONTEXT=\"" + contextRoot + "\";\nvar HTTP_PORT=" + httpPort + ";\nvar HTTPS_PORT=" + httpsPort + ";\n").getBytes();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting connection properties";
            log.error((Object)msg, (Throwable)e);
        }
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public String getContentType() {
        return "text/javascript";
    }

    @Override
    public int getContentLength() {
        return this.buf.length;
    }
}

