/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.filters.csrf;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ui.filters.csrf.CSRFConstants;
import org.wso2.carbon.ui.filters.csrf.CSRFException;
import org.wso2.carbon.ui.filters.csrf.CSRFFilterConfig;
import org.wso2.carbon.ui.filters.csrf.CSRFResponseWrapper;

public class CSRFProtector {
    private static final Log log = LogFactory.getLog(CSRFProtector.class);
    private static final String JS_TEMPLATE = "/web/admin/js/csrf.js";
    private CSRFFilterConfig config;
    private Pattern skipUrlPattern;
    private StringBuilder jsTemplate;

    public CSRFProtector(CSRFFilterConfig config) {
        this.config = config;
        this.initSkipUrlPattern(config.getSkipUrlPattern());
        this.loadJSTemplate();
    }

    public boolean skipUrl(String uri) {
        if (this.skipUrlPattern != null) {
            return this.skipUrlPattern.matcher(uri).matches();
        }
        return false;
    }

    public void applyProtection(HttpServletRequest request, CSRFResponseWrapper responseWrapper) throws CSRFException {
        HttpSession session = request.getSession(false);
        if (session != null && "POST".equalsIgnoreCase(request.getMethod())) {
            String CSRFRequestToken = request.getParameter("csrftoken");
            String CSRFSessionToken = this.getCSRFTokenFromSession(session);
            if (CSRFSessionToken == null || !CSRFSessionToken.equals(CSRFRequestToken)) {
                throw new CSRFException("A potential CSRF attack from " + request.getRequestURI());
            }
        }
    }

    public void enforceProtection(HttpServletRequest request, CSRFResponseWrapper responseWrapper) throws IOException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            String CSRFSessionToken = this.getCSRFTokenFromSession(session);
            if (CSRFSessionToken == null) {
                this.setCSRFTokenForSession(session);
            }
            CSRFSessionToken = this.getCSRFTokenFromSession(session);
            String content = new String(responseWrapper.getContent());
            content = CSRFConstants.HTML_HEAD_PATTERN.matcher(content).replaceAll("<script type=\"text/javascript\">\n" + Matcher.quoteReplacement(this.getInjectingJS(CSRFSessionToken)) + "\n</script>\n</head>");
            responseWrapper.setContent(content);
            responseWrapper.write();
        }
    }

    public CSRFFilterConfig getConfig() {
        return this.config;
    }

    private void initSkipUrlPattern(String regex) {
        if (StringUtils.isNotBlank((String)regex)) {
            this.skipUrlPattern = Pattern.compile(regex);
        }
    }

    private void loadJSTemplate() {
        this.jsTemplate = new StringBuilder();
        try (InputStream inputStream = this.getClass().getResourceAsStream(JS_TEMPLATE);){
            int i = 0;
            while ((i = inputStream.read()) > 0) {
                this.jsTemplate.append((char)i);
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to load CSRF javascript template", (Throwable)e);
        }
    }

    private String getCSRFTokenFromSession(HttpSession session) {
        return (String)session.getAttribute("csrftoken");
    }

    private void setCSRFTokenForSession(HttpSession session) {
        try {
            String token = CSRFProtector.generateCSRFToken();
            session.setAttribute("csrftoken", (Object)token);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"CSRF Token generation failed.", (Throwable)e);
        }
    }

    private String getInjectingJS(String token) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("CSRF_TOKEN_NAME", "csrftoken");
        valuesMap.put("CSRF_TOKEN_VALUE", token);
        StrSubstitutor substitutor = new StrSubstitutor(valuesMap);
        return substitutor.replace(this.jsTemplate.toString());
    }

    private static String generateCSRFToken() throws NoSuchAlgorithmException {
        byte[] random = new byte[16];
        StringBuilder buffer = new StringBuilder();
        SecureRandom.getInstance("DRBG").nextBytes(random);
        for (int j = 0; j < random.length; ++j) {
            byte b1 = (byte)((random[j] & 0xF0) >> 4);
            byte b2 = (byte)(random[j] & 0xF);
            if (b1 < 10) {
                buffer.append((char)(48 + b1));
            } else {
                buffer.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                buffer.append((char)(48 + b2));
                continue;
            }
            buffer.append((char)(65 + (b2 - 10)));
        }
        return buffer.toString();
    }
}

