/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.taglibs;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ui.taglibs.JSi18n;

public class SimpleItemGroupSelector
extends BodyTagSupport {
    private static final Log log = LogFactory.getLog(SimpleItemGroupSelector.class);
    protected String selectAllFunction;
    protected String selectNoneFunction;
    protected String selectAllKey;
    protected String selectNoneKey;
    protected String resourceBundle;

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getSelectAllFunction() {
        return this.selectAllFunction;
    }

    public void setSelectAllFunction(String selectAllFunction) {
        this.selectAllFunction = selectAllFunction;
    }

    public String getSelectNoneFunction() {
        return this.selectNoneFunction;
    }

    public void setSelectNoneFunction(String selectNoneFunction) {
        this.selectNoneFunction = selectNoneFunction;
    }

    public String getSelectAllKey() {
        return this.selectAllKey;
    }

    public void setSelectAllKey(String selectAllKey) {
        this.selectAllKey = selectAllKey;
    }

    public String getSelectNoneKey() {
        return this.selectNoneKey;
    }

    public void setSelectNoneKey(String selectNoneKey) {
        this.selectNoneKey = selectNoneKey;
    }

    public int doEndTag() throws JspException {
        String selectAll = "Select all in all pages";
        String selectNone = "Select none";
        if (this.resourceBundle != null) {
            try {
                Locale locale = JSi18n.getLocaleFromPageContext(this.pageContext);
                ResourceBundle bundle = ResourceBundle.getBundle(this.resourceBundle, locale);
                selectAll = bundle.getString(this.selectAllKey);
                selectNone = bundle.getString(this.selectNoneKey);
            }
            catch (Exception e) {
                log.warn((Object)"Error while i18ning SimpleItemGroupSelector", (Throwable)e);
            }
        }
        JspWriter writer = this.pageContext.getOut();
        String content = "<a href=\"#\" onclick=\"" + this.selectAllFunction + ";return false;\"  style=\"cursor:pointer\">" + selectAll + "</a>&nbsp<b>|</b>&nbsp;<a href=\"#\" onclick=\"" + this.selectNoneFunction + ";return false;\"  style=\"cursor:pointer\">" + selectNone + "</a>";
        try {
            writer.write(content);
        }
        catch (IOException e) {
            String msg = "Cannot write SimpleItemGroupSelector tag content";
            log.error((Object)msg, (Throwable)e);
            throw new JspException(msg, (Throwable)e);
        }
        return 0;
    }
}

