/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.filters.csrf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.wso2.carbon.ui.filters.csrf.ResponseWrapperOutputStream;

public final class CSRFResponseWrapper
extends HttpServletResponseWrapper {
    private HttpServletResponse originalResponse = null;
    private ByteArrayOutputStream output = null;
    private ResponseWrapperOutputStream stream = null;
    private PrintWriter writer = null;

    public CSRFResponseWrapper(HttpServletResponse response) {
        super(response);
        this.originalResponse = response;
        this.reset();
    }

    public void flushBuffer() throws IOException {
        this.writer.flush();
        this.stream.flush();
        this.output.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public void reset() {
        this.output = new ByteArrayOutputStream();
        this.stream = new ResponseWrapperOutputStream(this.output);
        this.writer = new PrintWriter((OutputStream)((Object)this.stream));
    }

    public void resetBuffer() {
        this.reset();
    }

    public HttpServletResponse getOriginalResponse() {
        return this.originalResponse;
    }

    public byte[] getContent() throws IOException {
        this.flushBuffer();
        return this.output.toByteArray();
    }

    public void setContent(byte[] content) throws IOException {
        this.reset();
        this.stream.write(content);
    }

    public void setContent(String s) throws IOException {
        this.setContent(s.getBytes());
    }

    public void write() throws IOException {
        this.writeContent();
    }

    private void writeContent() throws IOException {
        byte[] content = this.getContent();
        ServletResponse response = this.getResponse();
        ServletOutputStream os = response.getOutputStream();
        response.setContentLength(content.length);
        os.write(content);
        os.close();
    }
}

