/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ui.ComponentDeployer;
import org.wso2.carbon.ui.deployment.ComponentBuilder;
import org.wso2.carbon.ui.deployment.beans.Component;

public class DeploymentEngine {
    private Map<Long, Component> componentMap = new ConcurrentHashMap<Long, Component>();
    private ComponentDeployer componentDeployer;
    private static Log log = LogFactory.getLog(DeploymentEngine.class);
    private Bundle componentBundle;

    public DeploymentEngine(Bundle componentBundle) {
        this.componentBundle = componentBundle;
        this.componentDeployer = new ComponentDeployer(componentBundle);
    }

    public void process(Bundle registeredBundle) {
        try {
            URL url = registeredBundle.getEntry("META-INF/component.xml");
            if (url != null) {
                Dictionary headers = registeredBundle.getHeaders();
                String bundleName = (String)headers.get("Bundle-Name");
                String bundleVersion = (String)headers.get("Bundle-Version");
                InputStream inputStream = url.openStream();
                Component component = ComponentBuilder.build(inputStream, bundleName, bundleVersion, registeredBundle.getBundleContext());
                this.componentMap.put(registeredBundle.getBundleId(), component);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error((Object)"", (Throwable)e);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            log.error((Object)"", (Throwable)e);
        }
        catch (CarbonException e) {
            e.printStackTrace();
            log.error((Object)"", (Throwable)e);
        }
    }

    public void layout() throws CarbonException {
        this.componentDeployer.layout(this.componentMap);
    }
}

