/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonUILoginUtil;

public class CarbonSSOSessionManager {
    private static Log log = LogFactory.getLog(CarbonSSOSessionManager.class);
    private static CarbonSSOSessionManager instance = new CarbonSSOSessionManager();
    private ConcurrentHashMap<String, String> validSessionMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> invalidSessionsMap = new ConcurrentHashMap();

    private CarbonSSOSessionManager() {
    }

    public static CarbonSSOSessionManager getInstance() {
        return instance;
    }

    public void addSessionMapping(String idPSessionIndex, String localSessionId) {
        this.validSessionMap.put(idPSessionIndex, localSessionId);
    }

    public void makeSessionInvalid(String idPSessionIndex) {
        if (this.validSessionMap.containsKey(idPSessionIndex)) {
            this.invalidSessionsMap.put(this.validSessionMap.get(idPSessionIndex), idPSessionIndex);
            this.validSessionMap.remove(idPSessionIndex);
        }
    }

    public boolean isSessionValid(String localSessionId) {
        boolean isSessionValid = true;
        if (this.invalidSessionsMap.containsKey(localSessionId)) {
            isSessionValid = false;
        }
        return isSessionValid;
    }

    public void removeInvalidSession(String localSessionId) {
        if (this.invalidSessionsMap.containsKey(localSessionId)) {
            this.invalidSessionsMap.remove(localSessionId);
        }
    }

    public boolean skipSSOSessionInvalidation(HttpServletRequest request, CarbonUIAuthenticator uiAuthenticator) {
        String requestedURI = request.getRequestURI();
        if (uiAuthenticator != null) {
            List<String> skippingUrls = uiAuthenticator.getSessionValidationSkippingUrls();
            return this.skip(requestedURI, skippingUrls);
        }
        return false;
    }

    public boolean skipAuthentication(HttpServletRequest request) {
        String requestedURI = request.getRequestURI();
        CarbonUIAuthenticator uiAuthenticator = CarbonUILoginUtil.getAuthenticator(request);
        if (uiAuthenticator != null) {
            List<String> skippingUrls = uiAuthenticator.getAuthenticationSkippingUrls();
            return this.skip(requestedURI, skippingUrls);
        }
        return false;
    }

    public String getRequestedUrl(HttpServletRequest request, CarbonUIAuthenticator uiAuthenticator) {
        String requestedURI = request.getRequestURI();
        boolean skipSessionValidation = this.skipSSOSessionInvalidation(request, uiAuthenticator);
        boolean isSessionValid = this.isSessionValid(request.getSession().getId());
        if (!skipSessionValidation && !isSessionValid) {
            requestedURI = "/carbon/admin/logout_action.jsp";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request URI changed to " + requestedURI));
            }
        }
        if (skipSessionValidation && !isSessionValid) {
            this.removeInvalidSession(request.getSession().getId());
        }
        return requestedURI;
    }

    private boolean skip(String requestedURI, List<String> skippingUrls) {
        for (String skippingUrl : skippingUrls) {
            if (!requestedURI.contains(skippingUrl)) continue;
            return true;
        }
        return false;
    }
}

