/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.taglibs;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.taglibs.standard.tag.common.fmt.BundleSupport;
import org.wso2.carbon.ui.taglibs.JSi18n;

public class TooltipsGenerator
extends BodyTagSupport {
    private static final Log log = LogFactory.getLog(TooltipsGenerator.class);
    private String image;
    private String description;
    private int noOfWordsPerLine = 10;
    private String resourceBundle;
    private String key;

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getNoOfWordsPerLine() {
        return this.noOfWordsPerLine;
    }

    public void setNoOfWordsPerLine(int noOfWordsPerLine) {
        this.noOfWordsPerLine = noOfWordsPerLine;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int doEndTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        String context = "<link rel='stylesheet' type='text/css' href='../yui/build/container/assets/skins/sam/container.css'>\n<script type=\"text/javascript\" src=\"../yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script>\n<script type=\"text/javascript\" src=\"../yui/build/container/container-min.js\"></script>\n<script type=\"text/javascript\" src=\"../yui/build/element/element-min.js\"></script>\n<script type=\"text/javascript\" src=\"../admin/js/widgets.js\"></script>\n";
        if (this.getResourceBundle() != null && this.getKey() != null || this.getResourceBundle() == null && this.getKey() != null) {
            context = context + "<a target='_blank' class='icon-link' onmouseover=\"showTooltip(this,'" + this.getTooltipsContentFromKey() + "')\" style='background-image:url(\"" + this.getImage() + "\")' ></a>";
        } else if (this.description != null) {
            context = context + "<a target='_blank' class='icon-link' onmouseover=\"showTooltip(this,'" + this.createTooltipsBody(this.getNoOfWordsPerLine()) + "')\" style='background-image:url(\"" + this.getImage() + "\")' ></a>";
        }
        try {
            writer.write(context);
        }
        catch (IOException e) {
            String msg = "Cannot write tag content";
            throw new JspException(msg, (Throwable)e);
        }
        return 6;
    }

    public String createTooltipsBody(int noOfWordsPerLine) {
        String[] words;
        String toolTipContent = this.getDescription();
        if (toolTipContent != null && (words = toolTipContent.split(" ")).length > noOfWordsPerLine) {
            int countWords = 0;
            String descriptionNew = "";
            for (String word : words) {
                if (countWords != noOfWordsPerLine) {
                    descriptionNew = descriptionNew + " " + word;
                    ++countWords;
                    continue;
                }
                descriptionNew = descriptionNew + "<br>" + word;
                countWords = 0;
            }
            this.setDescription(descriptionNew);
        }
        return this.getDescription();
    }

    public String getTooltipsContentFromKey() throws JspException {
        ResourceBundle bundle = null;
        try {
            Locale locale = JSi18n.getLocaleFromPageContext(this.pageContext);
            if (this.getResourceBundle() != null && this.getKey() != null) {
                bundle = ResourceBundle.getBundle(this.getResourceBundle(), locale);
            } else if (this.getResourceBundle() == null && this.getKey() != null) {
                bundle = this.getCommonResourceBundleForJspPage();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error while i18ning.", (Throwable)e);
        }
        if (bundle != null) {
            String toolTipsContent = bundle.getString(this.getKey());
            this.setDescription(toolTipsContent);
        }
        return this.createTooltipsBody(this.getNoOfWordsPerLine());
    }

    public ResourceBundle getCommonResourceBundleForJspPage() {
        LocalizationContext localizationContext;
        Tag t = TooltipsGenerator.findAncestorWithClass((Tag)this, BundleSupport.class);
        if (t != null) {
            BundleSupport parent = (BundleSupport)t;
            localizationContext = parent.getLocalizationContext();
        } else {
            localizationContext = BundleSupport.getLocalizationContext((PageContext)this.pageContext);
        }
        return localizationContext.getResourceBundle();
    }
}

