/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.transports.fileupload;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;

public class JarZipUploadExecutor
extends AbstractFileUploadExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)servletRequestContext);
        response.setContentType("text/html; charset=utf-8");
        try (PrintWriter out = response.getWriter();){
            if (isMultipart) {
                List items = this.parseRequest(servletRequestContext);
                Map fileResourceMap = (Map)this.configurationContext.getProperty("file.resource.map");
                if (fileResourceMap == null) {
                    fileResourceMap = new TreeBidiMap();
                    this.configurationContext.setProperty("file.resource.map", (Object)fileResourceMap);
                }
                ArrayList<String> resourceUUID = new ArrayList<String>();
                String main = null;
                for (DiskFileItem item : items) {
                    String fileName;
                    if (item.isFormField()) continue;
                    String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
                    String extraFileLocation = this.configurationContext.getProperty("WORK_DIR") + File.separator + "extra" + File.separator + uuid + File.separator;
                    String fieldName = item.getFieldName();
                    if (fieldName != null && fieldName.equals("jarZipFilename")) {
                        String fileName2;
                        File dirs = new File(extraFileLocation);
                        dirs.mkdirs();
                        String fileExtension = fileName2 = item.getName();
                        this.checkServiceFileExtensionValidity(fileExtension, new String[]{".jar", ".zip"});
                        File uploadedFile = new File(extraFileLocation, this.getFileName(fileName2));
                        item.write(uploadedFile);
                        main = uuid;
                        resourceUUID.add(uuid);
                        fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                    }
                    if (fieldName == null || !fieldName.equals("jarResource") || !(fileName = item.getName()).toLowerCase().endsWith(".jar")) continue;
                    File dirs = new File(extraFileLocation);
                    dirs.mkdirs();
                    File uploadedFile = new File(extraFileLocation, this.getFileName(fileName));
                    item.write(uploadedFile);
                    resourceUUID.add(uuid);
                    fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                }
                if (main == null) {
                    out.write("<script type=\"text/javascript\">top.wso2.wsf.Util.alertWarning('Please upload a jar or a zip file.');</script>");
                }
                String s = "var uObj = new Object();";
                for (int i = 0; i < resourceUUID.size(); ++i) {
                    s = s + "uObj[" + i + "]=\"" + resourceUUID.get(i) + "\";\n";
                }
                out.write("<script type=\"text/javascript\">" + s + "top.jarZipFileUploadExecutor(\"" + main + "\",uObj);</script>");
                out.flush();
            }
        }
        return true;
    }
}

