/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.deployment.beans.BreadCrumbItem;

public class BreadCrumbGenerator {
    private static Log log = LogFactory.getLog(BreadCrumbGenerator.class);

    public HashMap<String, String> getBreadCrumbContent(HttpServletRequest request, BreadCrumbItem currentBreadcrumbItem, String jspFilePath, boolean topPage, boolean removeLastItem) {
        String params;
        HashMap indexPageBreadcrumbParamMap;
        String breadcrumbCookieString = "";
        StringBuffer content = new StringBuffer();
        StringBuffer cookieContent = new StringBuffer();
        HashMap<String, String> breadcrumbContents = new HashMap<String, String>();
        HashMap breadcrumbs = (HashMap)request.getSession().getAttribute("breadcrumbs");
        String menuId = request.getParameter("item");
        String region = request.getParameter("region");
        String ordinalStr = request.getParameter("ordinal");
        if (topPage && menuId == null && region == null && (indexPageBreadcrumbParamMap = (HashMap)request.getSession().getAttribute("index-page-breadcrumb-param-map")) != null && !indexPageBreadcrumbParamMap.isEmpty() && (params = (String)indexPageBreadcrumbParamMap.get(jspFilePath)) != null) {
            region = params.substring(0, params.indexOf(44));
            menuId = params.substring(params.indexOf(44) + 1);
        }
        if (menuId != null && region != null) {
            String key = region.trim() + "-" + menuId.trim();
            HashMap breadcrumbMap = (HashMap)request.getSession().getAttribute(region + "menu-id-breadcrumb-map");
            String breadCrumb = "";
            if (breadcrumbMap != null && !breadcrumbMap.isEmpty()) {
                breadCrumb = (String)breadcrumbMap.get(key);
            }
            if (breadCrumb != null) {
                content.append("<table cellspacing=\"0\"><tr>");
                Locale locale = CarbonUIUtil.getLocaleFromSession(request);
                String homeText = CarbonUIUtil.geti18nString("component.home", "org.wso2.carbon.i18n.Resources", locale);
                content.append("<td class=\"breadcrumb-link\"><a href=\"" + CarbonUIUtil.getHomePage() + "\">" + homeText + "</a></td>");
                cookieContent.append(breadCrumb);
                cookieContent.append("#");
                this.generateBreadcrumbForMenuPath(content, breadcrumbs, breadCrumb, true);
            }
        } else {
            HashMap links = (HashMap)request.getSession().getAttribute("page-breadcrumbs");
            Cookie[] cookies = request.getCookies();
            for (int a = 0; a < cookies.length; ++a) {
                Cookie cookie = cookies[a];
                if (!"current-breadcrumb".equals(cookie.getName())) continue;
                breadcrumbCookieString = cookie.getValue();
                breadcrumbCookieString = breadcrumbCookieString.replace("%2C", ",");
                breadcrumbCookieString = breadcrumbCookieString.replace("%23", "#");
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("cookie :" + cookie.getName() + " : " + breadcrumbCookieString));
            }
            if (links != null) {
                String tmp;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("size of page-breadcrumbs is : " + links.size()));
                }
                content.append("<table cellspacing=\"0\"><tr>");
                Locale locale = CarbonUIUtil.getLocaleFromSession(request);
                String homeText = CarbonUIUtil.geti18nString("component.home", "org.wso2.carbon.i18n.Resources", locale);
                content.append("<td class=\"breadcrumb-link\"><a href=\"" + CarbonUIUtil.getHomePage() + "\">" + homeText + "</a></td>");
                String menuBreadcrumbs = "";
                if (breadcrumbCookieString.indexOf(35) > -1) {
                    menuBreadcrumbs = breadcrumbCookieString.substring(0, breadcrumbCookieString.indexOf(35));
                }
                cookieContent.append(menuBreadcrumbs);
                cookieContent.append("#");
                this.generateBreadcrumbForMenuPath(content, breadcrumbs, menuBreadcrumbs, false);
                int clickedBreadcrumbLocation = 0;
                if (ordinalStr != null) {
                    try {
                        clickedBreadcrumbLocation = Integer.parseInt(ordinalStr);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)"Found String for breadcrumb ordinal");
                    }
                }
                String pageBreadcrumbs = "";
                if (breadcrumbCookieString.indexOf(35) > -1) {
                    pageBreadcrumbs = breadcrumbCookieString.substring(breadcrumbCookieString.indexOf(35) + 1);
                }
                StringTokenizer st2 = new StringTokenizer(pageBreadcrumbs, "*");
                String[] tokens = new String[st2.countTokens()];
                int count = 0;
                String previousToken = "";
                while (st2.hasMoreTokens()) {
                    String currentToken = st2.nextToken();
                    if (currentToken.equals(previousToken)) continue;
                    previousToken = currentToken;
                    tokens[count] = currentToken;
                    ++count;
                }
                List breadcrumbItems = null;
                LinkedList<String> tokenJSPFileOrder = new LinkedList<String>();
                LinkedList<String> jspFileSubContextOrder = new LinkedList<String>();
                HashMap<String, String> jspFileSubContextMap = new HashMap<String, String>();
                for (int a = 0; a < tokens.length; ++a) {
                    String token = tokens[a];
                    if (token == null) continue;
                    String jspFileName = token.substring(token.indexOf(43) + 1);
                    String jspSubContext = token.substring(0, token.indexOf(43));
                    jspFileSubContextMap.put(jspFileName, jspSubContext);
                    tokenJSPFileOrder.add(jspFileName);
                    jspFileSubContextOrder.add(jspSubContext + "^" + jspFileName);
                }
                if (clickedBreadcrumbLocation > 0) {
                    int tokenCount = tokenJSPFileOrder.size();
                    while (tokenCount > clickedBreadcrumbLocation) {
                        String lastItem = (String)tokenJSPFileOrder.getLast();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Removing breacrumbItem : " + lastItem));
                        }
                        tokenJSPFileOrder.removeLast();
                        jspFileSubContextOrder.removeLast();
                        tokenCount = tokenJSPFileOrder.size();
                    }
                }
                boolean lastBreadcrumbItemAvailable = false;
                if (clickedBreadcrumbLocation == 0 && !previousToken.equals(tmp = BreadCrumbGenerator.getSubContextFromUri(currentBreadcrumbItem.getLink()) + "+" + currentBreadcrumbItem.getId())) {
                    lastBreadcrumbItemAvailable = true;
                }
                if (tokenJSPFileOrder != null) {
                    for (int i = 0; i < jspFileSubContextOrder.size(); ++i) {
                        String token = (String)tokenJSPFileOrder.get(i);
                        String fileContextToken = (String)jspFileSubContextOrder.get(i);
                        String jspFileName = fileContextToken.substring(fileContextToken.indexOf(94) + 1);
                        String jspSubContext = fileContextToken.substring(0, fileContextToken.indexOf(94));
                        if (jspSubContext != null) {
                            breadcrumbItems = (List)links.get("../" + jspSubContext);
                        }
                        if (breadcrumbItems == null) continue;
                        int bcSize = breadcrumbItems.size();
                        for (int a = 0; a < bcSize; ++a) {
                            BreadCrumbItem tmp2 = (BreadCrumbItem)breadcrumbItems.get(a);
                            if (!tmp2.getId().equals(jspFileName)) continue;
                            if (tmp2.getLink().startsWith("#")) {
                                content.append("<td class=\"breadcrumb-link\">&nbsp;>&nbsp;" + tmp2.getConvertedText() + "</td>");
                            } else if (a + 1 == bcSize && !lastBreadcrumbItemAvailable || removeLastItem) {
                                content.append("<td class=\"breadcrumb-link\">&nbsp;>&nbsp;" + tmp2.getConvertedText() + "</td>");
                            } else {
                                content.append("<td class=\"breadcrumb-link\">&nbsp;>&nbsp;<a href=\"" + BreadCrumbGenerator.appendOrdinal(tmp2.getLink(), i + 1) + "\">" + tmp2.getConvertedText() + "</a></td>");
                            }
                            cookieContent.append(BreadCrumbGenerator.getSubContextFromUri(tmp2.getLink()) + "+" + token + "*");
                        }
                    }
                }
                if (lastBreadcrumbItemAvailable && !removeLastItem) {
                    tmp = BreadCrumbGenerator.getSubContextFromUri(currentBreadcrumbItem.getLink()) + "+" + currentBreadcrumbItem.getId();
                    cookieContent.append(tmp);
                    cookieContent.append("*");
                    content.append("<td class=\"breadcrumb-link\">&nbsp;>&nbsp;" + currentBreadcrumbItem.getConvertedText() + "</td>");
                }
                content.append("</tr></table>");
            }
        }
        breadcrumbContents.put("html-content", content.toString());
        String finalCookieContent = cookieContent.toString();
        if (removeLastItem && breadcrumbCookieString != null && breadcrumbCookieString.trim().length() > 0) {
            finalCookieContent = breadcrumbCookieString;
        }
        breadcrumbContents.put("cookie-content", finalCookieContent);
        return breadcrumbContents;
    }

    private static String getSubContextFromUri(String uri) {
        if (uri != null) {
            int jspExtensionLocation = uri.indexOf(".jsp");
            String tmp = uri.substring(0, jspExtensionLocation);
            tmp = tmp.replace("../", "");
            int firstSlashLocation = tmp.indexOf(47);
            return tmp.substring(0, firstSlashLocation);
        }
        return "";
    }

    private static String appendOrdinal(String url, int ordinal) {
        if (url != null) {
            if (url.indexOf(63) > -1) {
                return url + "&ordinal=" + ordinal;
            }
            return url + "?ordinal=" + ordinal;
        }
        return "#";
    }

    private void generateBreadcrumbForMenuPath(StringBuffer content, HashMap<String, BreadCrumbItem> breadcrumbs, String breadCrumb, boolean clickFromMenu) {
        StringTokenizer st = new StringTokenizer(breadCrumb, ",");
        int tokenCount = st.countTokens();
        int count = 0;
        while (st.hasMoreTokens()) {
            ++count;
            String token = st.nextToken();
            BreadCrumbItem breadcrumbItem = breadcrumbs.get(token);
            if (breadcrumbItem == null) continue;
            if (breadcrumbItem.getLink().startsWith("#")) {
                content.append("<td class=\"breadcrumb-link\">&nbsp;>&nbsp;" + breadcrumbItem.getConvertedText() + "</td>");
                continue;
            }
            if (count == tokenCount && clickFromMenu) {
                content.append("<td class=\"breadcrumb-link\">&nbsp;>&nbsp;" + breadcrumbItem.getConvertedText() + "</td>");
                continue;
            }
            content.append("<td class=\"breadcrumb-link\">&nbsp;>&nbsp;<a href=\"" + breadcrumbItem.getLink() + "\">" + breadcrumbItem.getConvertedText() + "</a></td>");
        }
    }
}

