/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.SortedSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.utils.CarbonUtils;

public class Utils {
    private static Log log = LogFactory.getLog(Utils.class);

    public static void transform(InputStream xmlStream, InputStream xslStream, OutputStream outputStream) throws TransformerException {
        StreamSource xmlStreamSource = new StreamSource(xmlStream);
        StreamSource xslStreamSource = new StreamSource(xslStream);
        StreamResult result = new StreamResult(outputStream);
        Transformer transformer = CarbonUtils.getSecureTransformerFactory().newTransformer(xslStreamSource);
        transformer.transform(xmlStreamSource, result);
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            String[] children;
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            for (String aChildren : children = sourceLocation.list()) {
                Utils.copyDirectory(new File(sourceLocation, aChildren), new File(targetLocation, aChildren));
            }
        } else {
            try (FileInputStream in = new FileInputStream(sourceLocation);
                 FileOutputStream out = new FileOutputStream(targetLocation);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
        }
    }

    private static void getFile(ZipEntry e, JarFile zippy, File targetLocation, SortedSet<String> dirsMade) throws IOException {
        File d;
        String dirName;
        byte[] b = new byte[1024];
        String zipName = e.getName();
        if (zipName.startsWith("/")) {
            zipName = zipName.substring(1);
        }
        if (!zipName.startsWith("ui")) {
            return;
        }
        if ((zipName = zipName.substring(2)).endsWith("/")) {
            return;
        }
        int ix = zipName.lastIndexOf(47);
        if (!(ix <= 0 || dirsMade.contains(dirName = zipName.substring(0, ix)) || (d = new File(targetLocation, dirName)).exists() && d.isDirectory())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deploying Directory: " + dirName));
            }
            if (!d.mkdirs()) {
                log.warn((Object)("Warning: unable to mkdir " + dirName));
            }
            dirsMade.add(dirName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deploying " + zipName));
        }
        File file = new File(targetLocation, zipName);
        try (FileOutputStream os = new FileOutputStream(file);
             InputStream is = zippy.getInputStream(e);){
            int n;
            while ((n = is.read(b)) > 0) {
                os.write(b, 0, n);
            }
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Utils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getWebContextName() {
        String value;
        String webContext = "carbon";
        ServerConfiguration sc = ServerConfiguration.getInstance();
        if (sc != null && (value = sc.getFirstProperty("WebContext")) != null) {
            webContext = value;
        }
        return webContext;
    }
}

