/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.clients;

import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.common.IFileDownload;
import org.wso2.carbon.core.commons.stub.filedownload.FileDownloadServiceStub;

public class FileDownloadServiceClient
implements IFileDownload {
    private static final Log log = LogFactory.getLog(FileDownloadServiceClient.class);
    private FileDownloadServiceStub stub;
    private HttpSession session;

    public FileDownloadServiceClient(ConfigurationContext ctx, String serverURL, String cookie, HttpSession session) throws AxisFault {
        this.session = session;
        String serviceEPR = serverURL + "FileDownloadService";
        this.stub = new FileDownloadServiceStub(ctx, serviceEPR);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        if (cookie != null) {
            options.setProperty("Cookie", (Object)cookie);
        }
    }

    public DataHandler downloadFile(String id) {
        try {
            return this.stub.downloadFile(id);
        }
        catch (RemoteException e) {
            log.error((Object)("File download failed. ID: " + id));
            return null;
        }
    }
}

