/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.base.ServerConfiguration;

public class CRLFPreventionFilter
implements Filter {
    private static final String CRLF_CONFIG_ENABLED_PROPERTY = "Security.CRLFPreventionConfig.Enabled";
    private static boolean CRLFPreventionEnabled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        if (serverConfiguration.getFirstProperty(CRLF_CONFIG_ENABLED_PROPERTY) != null && Boolean.parseBoolean(serverConfiguration.getFirstProperty(CRLF_CONFIG_ENABLED_PROPERTY))) {
            CRLFPreventionEnabled = true;
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (CRLFPreventionEnabled && servletResponse instanceof HttpServletResponse) {
            CRLFResponseWrapper responseWrapper = new CRLFResponseWrapper((HttpServletResponse)servletResponse);
            filterChain.doFilter(servletRequest, (ServletResponse)responseWrapper);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }

    protected static class CRLFResponseWrapper
    extends HttpServletResponseWrapper {
        public CRLFResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void addCookie(Cookie cookie) {
            cookie.setValue(this.sanitize(cookie.getValue()));
            super.addCookie(cookie);
        }

        public void addHeader(String name, String value) {
            super.addHeader(this.sanitize(name), this.sanitize(value));
        }

        public void setHeader(String name, String value) {
            super.setHeader(this.sanitize(name), this.sanitize(value));
        }

        public void sendRedirect(String location) throws IOException {
            super.sendRedirect(this.sanitize(location));
        }

        private String sanitize(String input) {
            if (StringUtils.isBlank((String)input)) {
                return input;
            }
            return input.replaceAll("(\\r|\\n|%0D|%0A|%0a|%0d)", "");
        }
    }
}

