/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.filters.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCachePreventionFilter
implements Filter {
    private static Log log = LogFactory.getLog(AbstractCachePreventionFilter.class);
    private static final String HEADER_NAME_CACHE_CONTROL = "Cache-Control";
    private static final String HEADER_VALUE_CACHE_CONTROL = "no-store, no-cache, must-revalidate, private";
    private static final String HEADER_NAME_EXPIRES = "Expires";
    private static final String HEADER_VALUE_EXPIRES = "0";
    private static final String HEADER_NAME_PRAGMA = "Pragma";
    private static final String HEADER_VALUE_PRAGMA = "no-cache";
    private static final String PARAM_NAME_HTTP_HEADERS = "httpHeaders";
    private static final String PARAM_NAME_PATTERNS = "patterns";
    private static final String PARAM_NAME_FILTER_ACTION = "filterAction";
    private static final String PARAM_VALUE_PATTERNS_ACTION_SKIP = "skip";
    private static final String PARAM_VALUE_PATTERNS_ACTION_ENFORCE = "enforce";
    private static final String DELIMITER_MULTI_VALUE = "\"\\s*,";
    private static final String DELIMITER_HEADER_NAME_VALUE = ":";
    private String patternAction;
    private ArrayList<Pattern> patternsList = new ArrayList();
    private Map<String, String> headersMap = new HashMap<String, String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initHeaders(filterConfig);
        this.initPatternsAndAction(filterConfig);
    }

    protected void initHeaders(FilterConfig filterConfig) throws ServletException {
        String httpHeadersParam = filterConfig.getInitParameter(PARAM_NAME_HTTP_HEADERS);
        if (StringUtils.isNotBlank((String)httpHeadersParam)) {
            String[] httpHeadersArray;
            for (String header : httpHeadersArray = httpHeadersParam.split(DELIMITER_MULTI_VALUE)) {
                header = header.trim();
                if (!StringUtils.isNotBlank((String)(header = header.replaceAll("\"", "")))) continue;
                String[] entry = header.split(DELIMITER_HEADER_NAME_VALUE);
                if (entry.length == 2) {
                    String headerName = entry[0].trim();
                    String headerValue = entry[1].trim();
                    this.headersMap.put(headerName, headerValue);
                    continue;
                }
                throw new ServletException("Malformed header [" + header + "] defined in the web.xml");
            }
        }
        if (this.headersMap.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Valid custom headers are not defined. Using default cache prevention headers");
            }
            this.headersMap.put(HEADER_NAME_CACHE_CONTROL, HEADER_VALUE_CACHE_CONTROL);
            this.headersMap.put(HEADER_NAME_EXPIRES, HEADER_VALUE_EXPIRES);
            this.headersMap.put(HEADER_NAME_PRAGMA, HEADER_VALUE_PRAGMA);
        }
    }

    protected void initPatternsAndAction(FilterConfig filterConfig) {
        String patternActionConfig;
        String patternsParam = filterConfig.getInitParameter(PARAM_NAME_PATTERNS);
        if (!StringUtils.isBlank((String)patternsParam)) {
            String[] patternsArray;
            for (String pattern : patternsArray = patternsParam.split(DELIMITER_MULTI_VALUE)) {
                pattern = pattern.replace("\"", "");
                this.patternsList.add(Pattern.compile(pattern.trim()));
            }
        }
        this.patternAction = StringUtils.equals((String)PARAM_VALUE_PATTERNS_ACTION_ENFORCE, (String)(patternActionConfig = filterConfig.getInitParameter(PARAM_NAME_FILTER_ACTION))) ? PARAM_VALUE_PATTERNS_ACTION_ENFORCE : PARAM_VALUE_PATTERNS_ACTION_SKIP;
    }

    protected boolean canApplyCachePreventionHeaders(String stringToBeMatched) {
        if (this.patternsList.isEmpty()) {
            return true;
        }
        boolean patternMatched = false;
        for (Pattern pattern : this.patternsList) {
            if (!pattern.matcher(stringToBeMatched).matches()) continue;
            patternMatched = true;
            break;
        }
        if (patternMatched) {
            return PARAM_VALUE_PATTERNS_ACTION_ENFORCE.equals(this.patternAction);
        }
        return PARAM_VALUE_PATTERNS_ACTION_SKIP.equals(this.patternAction);
    }

    protected void applyCachePreventionHeaders(HttpServletResponse response) {
        for (Map.Entry<String, String> headerEntry : this.headersMap.entrySet()) {
            response.setHeader(headerEntry.getKey(), headerEntry.getValue());
        }
    }

    public abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    public void destroy() {
    }
}

