/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.ContentHandler;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.core.DefaultInstanceManager;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.web.startup.TilesServlet;
import org.apache.tomcat.InstanceManager;
import org.eclipse.equinox.http.helper.ContextPathServletAdaptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.url.URLStreamHandlerService;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.ui.BasicAuthUIAuthenticator;
import org.wso2.carbon.ui.CarbonProtocol;
import org.wso2.carbon.ui.CarbonSSOSessionManager;
import org.wso2.carbon.ui.CarbonSecuredHttpContext;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.DefaultCarbonAuthenticator;
import org.wso2.carbon.ui.TextJavascriptHandler;
import org.wso2.carbon.ui.TilesJspServlet;
import org.wso2.carbon.ui.UIAuthenticationExtender;
import org.wso2.carbon.ui.UIResourceRegistry;
import org.wso2.carbon.ui.deployment.UIBundleDeployer;
import org.wso2.carbon.ui.deployment.beans.CarbonUIDefinitions;
import org.wso2.carbon.ui.deployment.beans.CustomUIDefenitions;
import org.wso2.carbon.ui.tracker.AuthenticatorRegistry;
import org.wso2.carbon.ui.transports.FileDownloadServlet;
import org.wso2.carbon.ui.transports.FileUploadServlet;
import org.wso2.carbon.ui.util.UIAnnouncementDeployer;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="core.ui.dscomponent", immediate=true)
public class CarbonUIServiceComponent {
    private static Log log = LogFactory.getLog(CarbonUIServiceComponent.class);
    private static PackageAdmin packageAdminInstance;
    private static RegistryService registryServiceInstance;
    private static HttpService httpServiceInstance;
    private static ConfigurationContextService ccServiceInstance;
    private static ServerConfigurationService serverConfiguration;
    private static RealmService realmService;
    private static CarbonTomcatService carbonTomcatService;
    private static List<UIAuthenticationExtender> authenticationExtenders;
    private BundleContext bundleContext;
    private Servlet adaptedJspServlet;

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            this.start(ctxt.getBundleContext());
            String webContextRoot = serverConfiguration.getFirstProperty("WebContextRoot");
            if (webContextRoot == null || webContextRoot.isEmpty()) {
                throw new RuntimeException("WebContextRoot can't be null or empty. It should be either '/' or '/[some value]'");
            }
            String adminConsoleURL = CarbonUIUtil.getAdminConsoleURL(webContextRoot);
            if (adminConsoleURL != null) {
                log.info((Object)("Mgt Console URL  : " + adminConsoleURL));
            }
            ServiceReference reference = ctxt.getBundleContext().getServiceReference(CarbonUIDefinitions.class.getName());
            CarbonUIDefinitions carbonUIDefinitions = null;
            if (reference != null && (carbonUIDefinitions = (CarbonUIDefinitions)ctxt.getBundleContext().getService(reference)) != null && carbonUIDefinitions.getContexts() != null) {
                if ("/".equals(webContextRoot)) {
                    webContextRoot = "";
                }
                int index = adminConsoleURL.lastIndexOf("carbon");
                String defContextUrl = adminConsoleURL.substring(0, index);
                if (!"".equals(webContextRoot)) {
                    defContextUrl = defContextUrl.replace(webContextRoot, "");
                }
                for (String key : carbonUIDefinitions.getContexts().keySet()) {
                    this.printAdditionalContext(carbonUIDefinitions.getContexts().get(key), defContextUrl);
                }
            }
            DefaultCarbonAuthenticator authenticator = new DefaultCarbonAuthenticator();
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("authenticator.type", authenticator.getAuthenticatorName());
            ctxt.getBundleContext().registerService(CarbonUIAuthenticator.class.getName(), (Object)authenticator, props);
            BasicAuthUIAuthenticator basicAuth = new BasicAuthUIAuthenticator();
            props = new Hashtable();
            props.put("authenticator.type", authenticator.getAuthenticatorName());
            ctxt.getBundleContext().registerService(CarbonUIAuthenticator.class.getName(), (Object)basicAuth, props);
            AuthenticatorRegistry.init(ctxt.getBundleContext());
            ctxt.getBundleContext().registerService(CarbonSSOSessionManager.class.getName(), (Object)CarbonSSOSessionManager.getInstance(), null);
            log.debug((Object)"Carbon UI bundle is activated ");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Carbon UI bundle ", e);
        }
    }

    private void printAdditionalContext(org.wso2.carbon.ui.deployment.beans.Context additionalContext, String defContextRoot) {
        if (additionalContext != null && !"".equals(additionalContext.getContextName()) && !"null".equals(additionalContext.getContextName())) {
            String defContextUrl = defContextRoot + additionalContext.getContextName();
            if (additionalContext.getDescription() != null) {
                if (additionalContext.getProtocol() != null && "http".equals(additionalContext.getProtocol())) {
                    log.info((Object)(additionalContext.getDescription() + " : " + CarbonUIUtil.https2httpURL(defContextUrl)));
                } else {
                    log.info((Object)(additionalContext.getDescription() + " : " + defContextUrl));
                }
            } else {
                log.info((Object)("Default Context : " + defContextUrl));
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Carbon UI bundle is deactivated ");
    }

    public static CarbonTomcatService getCarbonTomcatService() {
        return carbonTomcatService;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        ServerConfigurationService serverConfig = CarbonUIServiceComponent.getServerConfiguration();
        boolean isLocalTransportMode = this.checkForLocalTransportMode(serverConfig);
        ConfigurationContext clientConfigContext = CarbonUIServiceComponent.getConfigurationContextService().getClientConfigContext();
        ConfigurationContext serverConfigContext = CarbonUIServiceComponent.getConfigurationContextService().getServerConfigContext();
        CarbonUIDefinitions carbonUIDefinitions = new CarbonUIDefinitions();
        context.registerService(CarbonUIDefinitions.class.getName(), (Object)carbonUIDefinitions, null);
        CustomUIDefenitions customUIDefenitions = new CustomUIDefenitions();
        context.registerService(CustomUIDefenitions.class.getName(), (Object)customUIDefenitions, null);
        Hashtable<String, String[]> properties1 = new Hashtable<String, String[]>();
        properties1.put("url.handler.protocol", new String[]{"carbon"});
        context.registerService(URLStreamHandlerService.class.getName(), (Object)new CarbonProtocol(context), properties1);
        Hashtable<String, String[]> properties3 = new Hashtable<String, String[]>();
        properties3.put("url.content.mimetype", new String[]{"text/javascript"});
        context.registerService(ContentHandler.class.getName(), (Object)new TextJavascriptHandler(), properties3);
        HttpService httpService = CarbonUIServiceComponent.getHttpService();
        Hashtable<String, String> initparams = new Hashtable<String, String>();
        ((Dictionary)initparams).put("servlet-name", "TilesServlet");
        ((Dictionary)initparams).put("definitions-config", "/WEB-INF/tiles/main_defs.xml");
        ((Dictionary)initparams).put("org.apache.tiles.context.TilesContextFactory", "org.apache.tiles.context.enhanced.EnhancedContextFactory");
        ((Dictionary)initparams).put("org.apache.tiles.factory.TilesContainerFactory.MUTABLE", "true");
        ((Dictionary)initparams).put("org.apache.tiles.definition.DefinitionsFactory", "org.wso2.carbon.tiles.CarbonUrlDefinitionsFactory");
        String webContext = "carbon";
        String serverURL = CarbonUIUtil.getServerURL(serverConfig);
        String indexPageURL = CarbonUIUtil.getIndexPageURL(serverConfig);
        if (indexPageURL == null) {
            indexPageURL = "/carbon/admin/index.jsp";
        }
        RegistryService registryService = CarbonUIServiceComponent.getRegistryService();
        UserRegistry registry = registryService.getLocalRepository();
        UIBundleDeployer uiBundleDeployer = new UIBundleDeployer();
        UIResourceRegistry uiResourceRegistry = new UIResourceRegistry();
        uiResourceRegistry.initialize(this.bundleContext);
        uiResourceRegistry.setDefaultUIResourceProvider(uiBundleDeployer.getBundleBasedUIResourcePrvider());
        CarbonSecuredHttpContext commonContext = new CarbonSecuredHttpContext(context.getBundle(), "/web", uiResourceRegistry, (Registry)registry);
        ContextPathServletAdaptor fileDownloadServlet = new ContextPathServletAdaptor((Servlet)new FileDownloadServlet(context, CarbonUIServiceComponent.getConfigurationContextService()), "/filedownload");
        httpService.registerServlet("/filedownload", (Servlet)fileDownloadServlet, null, (HttpContext)commonContext);
        fileDownloadServlet.getServletConfig().getServletContext().setAttribute("ServerURL", (Object)serverURL);
        fileDownloadServlet.getServletConfig().getServletContext().setAttribute("IndexPageURL", (Object)indexPageURL);
        ContextPathServletAdaptor fileUploadServlet = isLocalTransportMode ? new ContextPathServletAdaptor((Servlet)new FileUploadServlet(context, serverConfigContext, webContext), "/fileupload") : new ContextPathServletAdaptor((Servlet)new FileUploadServlet(context, clientConfigContext, webContext), "/fileupload");
        httpService.registerServlet("/fileupload", (Servlet)fileUploadServlet, null, (HttpContext)commonContext);
        fileUploadServlet.getServletConfig().getServletContext().setAttribute("ServerURL", (Object)serverURL);
        fileUploadServlet.getServletConfig().getServletContext().setAttribute("IndexPageURL", (Object)indexPageURL);
        uiBundleDeployer.deploy(this.bundleContext, (HttpContext)commonContext);
        context.addBundleListener((BundleListener)uiBundleDeployer);
        httpService.registerServlet("/", (Servlet)new TilesServlet(), initparams, (HttpContext)commonContext);
        httpService.registerResources("/" + webContext, "/", (HttpContext)commonContext);
        this.adaptedJspServlet = new ContextPathServletAdaptor((Servlet)new TilesJspServlet(context.getBundle(), uiResourceRegistry), "/" + webContext);
        Hashtable<String, String> carbonInitparams = new Hashtable<String, String>();
        ((Dictionary)carbonInitparams).put("strictQuoteEscaping", "false");
        httpService.registerServlet("/" + webContext + "/*.jsp", this.adaptedJspServlet, carbonInitparams, (HttpContext)commonContext);
        ServletContext jspServletContext = this.adaptedJspServlet.getServletConfig().getServletContext();
        jspServletContext.setAttribute(InstanceManager.class.getName(), (Object)this.getTomcatInstanceManager());
        jspServletContext.setAttribute("registry", (Object)registryService);
        jspServletContext.setAttribute("ServerConfiguration", (Object)serverConfig);
        jspServletContext.setAttribute("ClientConfigurationContext", (Object)clientConfigContext);
        if (isLocalTransportMode) {
            jspServletContext.setAttribute("ConfigurationContext", (Object)serverConfigContext);
        } else {
            jspServletContext.setAttribute("ConfigurationContext", (Object)clientConfigContext);
        }
        jspServletContext.setAttribute("BundleClassLoader", (Object)this.getClass().getClassLoader());
        jspServletContext.setAttribute("ServerURL", (Object)serverURL);
        jspServletContext.setAttribute("IndexPageURL", (Object)indexPageURL);
        jspServletContext.setAttribute("carbon.ui.bundle.context", (Object)this.bundleContext);
        jspServletContext.setAttribute("customUIDefinitions", (Object)customUIDefenitions);
        this.bundleContext.registerService(ServletContext.class.getName(), (Object)jspServletContext, null);
        CarbonUIUtil.setBundleContext(context);
        UIAnnouncementDeployer.deployNotificationSources();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting web console using context : " + webContext));
        }
        this.readProductXML(jspServletContext, uiBundleDeployer);
    }

    private InstanceManager getTomcatInstanceManager() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String webContextRoot = CarbonUIServiceComponent.getServerConfiguration().getFirstProperty("WebContextRoot");
        NamingContextListener ncl = new NamingContextListener();
        ncl.setName("/Catalina/localhost" + webContextRoot);
        ncl.setExceptionOnFailedWrite(true);
        javax.naming.Context context = ncl.getEnvContext();
        HashMap injectionMap = new HashMap();
        ClassLoader containerClassloader = this.getClass().getClassLoader();
        StandardContext dummyCtx = new StandardContext();
        dummyCtx.setName("carbon");
        dummyCtx.setPath(webContextRoot);
        dummyCtx.setDocBase(System.getProperty("java.io.tmpdir"));
        dummyCtx.setLoader((Loader)Class.forName("org.apache.catalina.loader.WebappLoader").newInstance());
        return new DefaultInstanceManager(context, injectionMap, (Context)dummyCtx, containerClassloader);
    }

    private void readProductXML(ServletContext jspServletContext, UIBundleDeployer uiBundleDeployer) throws IOException, XMLStreamException {
        Enumeration e = this.bundleContext.getBundle().findEntries("META-INF", "product.xml", true);
        if (e != null) {
            URL url = (URL)e.nextElement();
            InputStream inputStream = url.openStream();
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(streamReader);
            OMElement document = builder.getDocumentElement();
            OMElement propsEle = document.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "properties"));
            if (propsEle != null) {
                Iterator properties = propsEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "property"));
                while (properties.hasNext()) {
                    OMElement property = (OMElement)properties.next();
                    String propertyName = property.getAttributeValue(new QName("name"));
                    String value = property.getText();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("product.xml: " + propertyName + "=" + value));
                    }
                    if ("collapsedmenus".equals(propertyName)) {
                        ArrayList<String> collapsedMenuItems = new ArrayList<String>();
                        if (value != null && value.indexOf(44) > -1) {
                            StringTokenizer st = new StringTokenizer(value, ",");
                            while (st.hasMoreTokens()) {
                                collapsedMenuItems.add(st.nextToken());
                            }
                        } else {
                            collapsedMenuItems.add(value);
                        }
                        jspServletContext.setAttribute("WSO2Carbon" + propertyName, collapsedMenuItems);
                        CarbonUIUtil.setProductParam("WSO2Carbon" + propertyName, collapsedMenuItems);
                        continue;
                    }
                    jspServletContext.setAttribute("WSO2Carbon" + propertyName, (Object)value);
                    CarbonUIUtil.setProductParam("WSO2Carbon" + propertyName, value);
                }
            }
        }
    }

    public static synchronized Bundle getBundle(Class clazz) {
        if (packageAdminInstance == null) {
            throw new IllegalStateException("Not started");
        }
        return packageAdminInstance.getBundle(clazz);
    }

    @Reference(name="config.context.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        ccServiceInstance = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        ccServiceInstance = null;
    }

    @Reference(name="tomcat.service.provider", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonTomcatService")
    protected void setCarbonTomcatService(CarbonTomcatService contextService) {
        carbonTomcatService = contextService;
    }

    protected void unsetCarbonTomcatService(CarbonTomcatService contextService) {
        carbonTomcatService = null;
    }

    @Reference(name="registry.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        registryServiceInstance = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        registryServiceInstance = null;
    }

    @Reference(name="server.configuration", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfiguration) {
        CarbonUIServiceComponent.serverConfiguration = serverConfiguration;
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfiguration) {
        CarbonUIServiceComponent.serverConfiguration = null;
    }

    @Reference(name="package.admin", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetPackageAdmin")
    protected void setPackageAdmin(PackageAdmin packageAdmin) {
        packageAdminInstance = packageAdmin;
    }

    protected void unsetPackageAdmin(PackageAdmin packageAdmin) {
        packageAdminInstance = null;
    }

    @Reference(name="http.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        httpServiceInstance = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        httpServiceInstance = null;
    }

    @Reference(name="user.realmservice.default", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        CarbonUIServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        CarbonUIServiceComponent.realmService = null;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="ui.authentication.extender", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetUIAuthenticationExtender")
    protected void setUIAuthenticationExtender(UIAuthenticationExtender authenticationExtender) {
        authenticationExtenders.add(authenticationExtender);
    }

    protected void unsetUIAuthenticationExtender(UIAuthenticationExtender authenticationExtender) {
        authenticationExtenders.remove(authenticationExtender);
    }

    public static UIAuthenticationExtender[] getUIAuthenticationExtenders() {
        return authenticationExtenders.toArray(new UIAuthenticationExtender[authenticationExtenders.size()]);
    }

    public static HttpService getHttpService() {
        if (httpServiceInstance == null) {
            String msg = "Before activating Carbon UI bundle, an instance of " + HttpService.class.getName() + " should be in existence";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return httpServiceInstance;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        if (ccServiceInstance == null) {
            String msg = "Before activating Carbon UI bundle, an instance of UserRealm service should be in existence";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return ccServiceInstance;
    }

    public static RegistryService getRegistryService() {
        if (registryServiceInstance == null) {
            String msg = "Before activating Carbon UI bundle, an instance of RegistryService should be in existence";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return registryServiceInstance;
    }

    public static ServerConfigurationService getServerConfiguration() {
        if (serverConfiguration == null) {
            String msg = "Before activating Carbon UI bundle, an instance of ServerConfiguration Service should be in existence";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return serverConfiguration;
    }

    public static PackageAdmin getPackageAdmin() throws Exception {
        if (packageAdminInstance == null) {
            String msg = "Before activating Carbon UI bundle, an instance of PackageAdmin Service should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return packageAdminInstance;
    }

    private boolean checkForLocalTransportMode(ServerConfigurationService serverConfiguration) {
        String serverURL = serverConfiguration.getFirstProperty("ServerURL");
        if (serverURL != null && (serverURL.startsWith("local") || serverURL.startsWith("Local") || serverURL.startsWith("LOCAL"))) {
            System.setProperty("localTransportModeEnabled", "true");
            return true;
        }
        return false;
    }

    static {
        authenticationExtenders = new LinkedList<UIAuthenticationExtender>();
    }
}

